/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class FormatDateTag
extends TagSupport {
    private Date mValue = null;
    private String mTimeZone = null;
    private String mPattern = "";

    public void setValue(Date value) {
        this.mValue = value;
    }

    public void setTimeZone(String timeZone) {
        this.mTimeZone = timeZone;
    }

    public void setPattern(String pattern) {
        this.mPattern = pattern;
    }

    public int doEndTag() throws JspException {
        try {
            SimpleDateFormat format;
            try {
                format = new SimpleDateFormat(this.mPattern, Locale.US);
            }
            catch (IllegalArgumentException e2) {
                Logs.APP_LOG.warn((Object)("internal error: date format wrong " + this.mPattern), (Throwable)e2);
                return 6;
            }
            TimeZone tz = null;
            tz = this.mTimeZone == null || "".equals(this.mTimeZone) ? AppConfig.getUserTimeZone((HttpServletRequest)this.pageContext.getRequest()) : TimeZone.getTimeZone(this.mTimeZone);
            format.setTimeZone(tz);
            String result = this.mValue == null ? "" : format.format(this.mValue);
            ExpressionUtil.escapeString(result, (Writer)this.pageContext.getOut());
            return 6;
        }
        catch (IOException e3) {
            throw new JspException((Throwable)e3);
        }
    }
}

