/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.tags.AsJavascriptStringTag;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.exception.Nestable;

public class ExpressionUtil {
    public static String deprecatedUrlPathEncode(Object s2) {
        if (s2 == null) {
            return "";
        }
        return FishEyeURLEncoder.pathEncode(s2.toString());
    }

    public static String uriEncode(Object s2) {
        if (s2 == null) {
            return "";
        }
        return FishEyeURLEncoder.uriEncode(s2.toString());
    }

    public static long cast2long(Number n2) {
        if (n2 == null) {
            return 0L;
        }
        return n2.longValue();
    }

    public static int cast2int(Number n2) {
        if (n2 == null) {
            return 0;
        }
        return n2.intValue();
    }

    public static Iterator<String> stringIterator(Object str) {
        if (str == null) {
            return Collections.emptyList().iterator();
        }
        final String s2 = str.toString();
        return new Iterator<String>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < s2.length();
            }

            @Override
            public String next() {
                char c2 = s2.charAt(this.i);
                ++this.i;
                return Character.toString(c2);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Object aref(Object list, int index) {
        List l2 = ExpressionUtil.asList(list);
        if (list == null) {
            return null;
        }
        return l2.get(index);
    }

    public static List asList(Object o2) {
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof List) {
            return (List)o2;
        }
        if (o2 instanceof Collection) {
            return new ArrayList((Collection)o2);
        }
        if (o2 instanceof Map) {
            return new ArrayList(((Map)o2).entrySet());
        }
        if (o2.getClass().isArray()) {
            Object[] array;
            if (o2.getClass().getComponentType().isPrimitive()) {
                array = new Object[Array.getLength(o2)];
                for (int i2 = 0; i2 < array.length; ++i2) {
                    array[i2] = Array.get(o2, i2);
                }
            } else {
                array = (Object[])o2;
            }
            return Arrays.asList(array);
        }
        return null;
    }

    public static Collection asCollection(Object o2) {
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Collection) {
            return (Collection)o2;
        }
        if (o2.getClass().isArray()) {
            Object[] array;
            if (o2.getClass().getComponentType().isPrimitive()) {
                array = new Object[Array.getLength(o2)];
                for (int i2 = 0; i2 < array.length; ++i2) {
                    array[i2] = Array.get(o2, i2);
                }
            } else {
                array = (Object[])o2;
            }
            return Arrays.asList(array);
        }
        return null;
    }

    public static boolean contains(Object collection, Object o2) {
        Collection c2 = ExpressionUtil.asCollection(collection);
        if (c2 == null) {
            return false;
        }
        return c2.contains(o2);
    }

    public static int computeLength(Object list) {
        if (list == null) {
            return 0;
        }
        if (list instanceof Map) {
            return ((Map)list).size();
        }
        if (list instanceof Collection) {
            return ((Collection)list).size();
        }
        if (list.getClass().isArray()) {
            return Array.getLength(list);
        }
        if (list instanceof CharSequence) {
            return ((CharSequence)list).length();
        }
        return 0;
    }

    public static Object mapGet(String key, Map map) {
        return map.get(key);
    }

    public static ValueExpression parseExpression(PageContext pageContext, String expr, Class desiredType) {
        JspApplicationContext jspac = JspFactory.getDefaultFactory().getJspApplicationContext(pageContext.getServletContext());
        ExpressionFactory ee = jspac.getExpressionFactory();
        return ee.createValueExpression(pageContext.getELContext(), expr, desiredType);
    }

    public static String escapeJavaScriptString(CharSequence s2) {
        if (s2 == null) {
            return "";
        }
        StringWriter w2 = new StringWriter();
        try {
            AsJavascriptStringTag.escape(new StringReader(s2.toString()), w2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ((Object)w2).toString();
    }

    public static void escapeString(CharSequence s2, Writer w2, int start, int len) throws IOException {
        if (s2 == null) {
            return;
        }
        for (int i2 = start; i2 < start + len; ++i2) {
            char c2 = s2.charAt(i2);
            ExpressionUtil.escapeChar(c2, w2);
        }
    }

    public static void escapeString(CharSequence s2, Writer w2) throws IOException {
        if (s2 == null) {
            return;
        }
        ExpressionUtil.escapeString(s2, w2, 0, s2.length());
    }

    public static String escapeString(CharSequence s2) {
        StringWriter out = new StringWriter();
        try {
            ExpressionUtil.escapeString(s2, out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public static void escapeChar(char c2, Writer w2) throws IOException {
        if (c2 == '&') {
            w2.write("&amp;");
        } else if (c2 == '<') {
            w2.write("&lt;");
        } else if (c2 == '>') {
            w2.write("&gt;");
        } else if (c2 == '\"') {
            w2.write("&#034;");
        } else if (c2 == '\'') {
            w2.write("&#039;");
        } else if (c2 > '\u0080') {
            w2.write("&#" + c2 + ";");
        } else {
            w2.write(c2);
        }
    }

    public static String escapeForJquery(Object o2) {
        if (o2 == null) {
            return null;
        }
        String input = o2.toString();
        input = input.replaceAll("\\.", "-");
        return input.replace(":", "-");
    }

    public static String escapeHtmlIdOrName(Object o2) {
        if (o2 == null) {
            return null;
        }
        return ExpressionUtil.escapeHtmlIdOrName(o2.toString());
    }

    public static String toLowerCase(String value) {
        return value == null ? null : value.toLowerCase(Locale.US);
    }

    public static String getRequestURI(HttpServletRequest req) {
        String requestURI;
        StringBuffer url = new StringBuffer(48);
        String scheme = req.getScheme();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        int port = req.getServerPort();
        if (port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
            url.append(':');
            url.append(port);
        }
        if ((requestURI = (String)req.getAttribute("fisheye.forward.request_uri")) == null) {
            requestURI = req.getRequestURI();
        }
        url.append(requestURI);
        return url.toString();
    }

    public static String escapeHtmlIdOrName(CharSequence s2) {
        if (s2 == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        block3: for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (i2 == 0 && !ExpressionUtil.isAsciiLetter(c2) || c2 == 'Z') {
                out.append('Z');
            }
            if (ExpressionUtil.isAsciiLetterOrDigit(c2)) {
                out.append(c2);
                continue;
            }
            switch (c2) {
                case '-': 
                case '.': 
                case '_': {
                    out.append(c2);
                    continue block3;
                }
                default: {
                    out.append('Z');
                    String hex = Integer.toHexString(c2);
                    StringUtil.append(out, "0", 4 - hex.length());
                    out.append(hex);
                }
            }
        }
        return out.toString();
    }

    public static boolean isAsciiLetterOrDigit(char c2) {
        return ExpressionUtil.isAsciiDigit(c2) || ExpressionUtil.isAsciiLetter(c2);
    }

    public static boolean isAsciiDigit(char c2) {
        return '0' <= c2 && c2 <= '9';
    }

    public static boolean isAsciiLetter(char c2) {
        return 'A' <= c2 && c2 <= 'Z' || 'a' <= c2 && c2 <= 'z';
    }

    public static Path[] abbreviatePathComponents(Path path, int maxLen) {
        return path.abbreviatePathComponents(maxLen);
    }

    public static List<RepositoryHandle> repositories(HttpServletRequest request) {
        return RepositoryUtil.repositories(request);
    }

    public static String pluralise(String singular, String plural, int count) {
        return count != 1 ? plural : singular;
    }

    public static void logDebugException(Throwable t2) {
        Logs.APP_LOG.debug((Object)("Exception in JSP Processing: " + t2.getMessage()), t2);
    }

    public static List<String> extractThrowableMessages(Throwable t2) {
        LinkedList<String> msgs = new LinkedList<String>();
        ExpressionUtil.collectMessages(t2, msgs);
        return msgs;
    }

    private static void collectMessages(Throwable t2, List<String> msgs) {
        if (t2 != null) {
            if (t2 instanceof Nestable) {
                msgs.addAll(Arrays.asList(((Nestable)t2).getMessages()));
            } else {
                msgs.add(t2.getMessage());
                ExpressionUtil.collectMessages(t2.getCause(), msgs);
            }
            if (t2 instanceof SQLException) {
                ExpressionUtil.collectMessages(((SQLException)t2).getNextException(), msgs);
            }
        }
    }

    public static String formatDurationMsAsMinutes(long milliseconds) {
        return DateHelper.formatDurationMinutes(Math.round((double)milliseconds / 60000.0));
    }

    public static String numbersToJsArray(Iterable<? extends Number> numbers) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator<? extends Number> i2 = numbers.iterator();
        while (i2.hasNext()) {
            Number n2 = i2.next();
            sb.append(n2.toString());
            if (!i2.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

