/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import com.google.common.base.Strings;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

@Deprecated
public class DateTag
extends TagSupport {
    public static final String DATE_BRIEF = "brief";
    public static final String DATE_NOTIME = "notime";
    public static final String DATE_FULL = "full";
    public static final String DATE_RSS = "rss";
    public static final String AGE_EXACT = "age";
    public static final String FUZZY = "fuzzy";
    public static final String FUZZY_TIME = "fuzzytime";
    public static final String FUZZY_CUSTOM = "fuzzycustom";
    public static final String CUSTOM = "custom";
    private static final String FORMAT_BRIEF_TODAY = "HH:mm";
    private static final String FORMAT_BRIEF_THIS_YEAR = "dd MMM";
    private static final String FORMAT_BRIEF_FULL = "dd MMM yy";
    private static final String FORMAT_FULL = "dd MMMM yyyy H:mm";
    private static final String FORMAT_RSS = "EEE, dd MMM yyyy, HH:mm:ss Z";
    private static final String PAGECONTEXT_RENDER_TIMESTAMP = "__page_render_timestamp";
    private Params params = new Params();

    public int doEndTag() throws JspException {
        if (this.params.date == null) {
            return 6;
        }
        if (this.params.now == null) {
            this.params.now = this.getPageRenderTimestamp();
        }
        if (Strings.isNullOrEmpty((String)this.params.inline) && Strings.isNullOrEmpty((String)this.params.brackets) && Strings.isNullOrEmpty((String)this.params.hover)) {
            this.params.inline = DATE_BRIEF;
            this.params.hover = DATE_FULL;
        }
        this.params.timeZone = Strings.isNullOrEmpty((String)this.params.timeZoneStr) ? AppConfig.getUserTimeZone((HttpServletRequest)this.pageContext.getRequest()) : TimeZone.getTimeZone(this.params.timeZoneStr);
        try {
            String renderedBrackets;
            String renderedHover;
            JspWriter out = this.pageContext.getOut();
            out.write("<span");
            if (!Strings.isNullOrEmpty((String)this.params.cssClass)) {
                out.write(" class=\"" + this.params.cssClass + "\"");
            }
            if (!Strings.isNullOrEmpty((String)(renderedHover = this.renderLayout(this.params.hover)))) {
                out.write(" title=\"" + ExpressionUtil.escapeString(renderedHover) + "\"");
            }
            out.write(">");
            String renderedInline = this.renderLayout(this.params.inline);
            if (!Strings.isNullOrEmpty((String)renderedInline)) {
                out.write(ExpressionUtil.escapeString(renderedInline));
            }
            if (!Strings.isNullOrEmpty((String)(renderedBrackets = this.renderLayout(this.params.brackets)))) {
                if (!Strings.isNullOrEmpty((String)renderedInline)) {
                    out.write("&nbsp;");
                }
                out.write("(" + ExpressionUtil.escapeString(renderedBrackets) + ")");
            }
            out.write("</span>");
            int n2 = 6;
            return n2;
        }
        catch (IOException e2) {
            throw new JspException((Throwable)e2);
        }
        finally {
            this.params = new Params();
        }
    }

    private Date getPageRenderTimestamp() {
        Date now = (Date)this.pageContext.getAttribute(PAGECONTEXT_RENDER_TIMESTAMP);
        if (now == null) {
            now = new Date();
            this.pageContext.setAttribute(PAGECONTEXT_RENDER_TIMESTAMP, (Object)now);
        }
        return now;
    }

    private String renderLayout(String type) {
        if (type == null) {
            return null;
        }
        if (FUZZY.equalsIgnoreCase(type)) {
            return DateHelper.fuzzyDate(this.params.date.getTime(), this.params.now.getTime(), this.params.timeZone, this.pageContext.getRequest().getLocale());
        }
        if (AGE_EXACT.equalsIgnoreCase(type)) {
            return DateHelper.age(this.params.date.getTime(), this.params.now.getTime());
        }
        if (FUZZY_TIME.equalsIgnoreCase(type)) {
            return DateHelper.fuzzyTime(this.params.date, this.params.now, this.params.timeZone, this.pageContext.getRequest().getLocale());
        }
        if (FUZZY_CUSTOM.equalsIgnoreCase(type)) {
            return DateHelper.fuzzyTime(this.params.date, this.params.now, this.params.timeZone, this.pageContext.getRequest().getLocale(), this.params.pattern);
        }
        if (DATE_RSS.equalsIgnoreCase(type)) {
            return this.df(FORMAT_RSS).format(this.params.date);
        }
        if (DATE_FULL.equalsIgnoreCase(type)) {
            return this.df(FORMAT_FULL).format(this.params.date);
        }
        if (DATE_NOTIME.equalsIgnoreCase(type)) {
            return this.df(FORMAT_BRIEF_FULL).format(this.params.date);
        }
        if (DATE_BRIEF.equalsIgnoreCase(type)) {
            String atOrOn = "";
            if (this.params.atOrOn) {
                atOrOn = DateHelper.getDayRelation(this.params.now, this.params.date, this.params.timeZone) == DateHelper.Relation.TODAY ? "at " : "on ";
            }
            if (this.params.now.getTime() < this.params.date.getTime()) {
                return atOrOn + this.df(FORMAT_BRIEF_FULL).format(this.params.date);
            }
            if (DateHelper.getDayRelation(this.params.now, this.params.date, this.params.timeZone) == DateHelper.Relation.TODAY) {
                return atOrOn + this.df(FORMAT_BRIEF_TODAY).format(this.params.date);
            }
            if (DateHelper.sameDateComponent(this.params.now, this.params.date, 1)) {
                return atOrOn + this.df(FORMAT_BRIEF_THIS_YEAR).format(this.params.date);
            }
            return atOrOn + this.df(FORMAT_BRIEF_FULL).format(this.params.date);
        }
        if (CUSTOM.equalsIgnoreCase(type)) {
            if (Strings.isNullOrEmpty((String)this.params.pattern)) {
                throw new IllegalArgumentException("Must set pattern attribute if specifying custom date type.");
            }
            return this.df(this.params.pattern).format(this.params.date);
        }
        throw new IllegalArgumentException("'" + type + "' is not a valid date type.");
    }

    private DateFormat df(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format, Locale.US);
        df.setTimeZone(this.params.timeZone);
        return df;
    }

    public void setDate(Date date) {
        this.params.date = date;
    }

    public void setNow(Date now) {
        this.params.now = now;
    }

    public void setTimeZone(String timeZone) {
        this.params.timeZoneStr = timeZone;
    }

    public void setPattern(String pattern) {
        this.params.pattern = pattern;
    }

    public void setHover(String hover) {
        this.params.hover = hover;
    }

    public void setBrackets(String brackets) {
        this.params.brackets = brackets;
    }

    public void setInline(String inline) {
        this.params.inline = inline;
    }

    public void setCssClass(String cssClass) {
        this.params.cssClass = cssClass;
    }

    public void setAtOrOn(Boolean atOrOn) {
        this.params.atOrOn = atOrOn == null ? false : atOrOn;
    }

    private static class Params {
        Date date;
        Date now;
        String timeZoneStr;
        String pattern;
        String hover;
        String brackets;
        String inline;
        String cssClass;
        boolean atOrOn;
        TimeZone timeZone;

        private Params() {
        }
    }
}

