/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.web.JspUtils;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class AgeTag
extends TagSupport {
    private Date mBirth = null;
    private Date mNow = null;
    private Boolean mReversed = false;
    private HttpServletRequest request = null;
    private boolean fuzzy = false;
    private FecruUser user = null;

    public void setBirth(Date aBirth) {
        this.mBirth = aBirth;
    }

    public void setNow(Date aNow) {
        this.mNow = aNow == null ? new Date() : aNow;
    }

    public void setReversed(Boolean aReversed) {
        this.mReversed = aReversed;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setFuzzy(boolean fuzzy) {
        this.fuzzy = fuzzy;
    }

    public void setUser(FecruUser user) {
        this.user = user;
    }

    public int doEndTag() throws JspException {
        Date now;
        Date birth = this.mBirth;
        if (birth == null) {
            if (this.mReversed.booleanValue()) {
                birth = new Date();
            } else {
                return 6;
            }
        }
        if ((now = this.mNow) == null) {
            now = new Date();
        }
        try {
            JspUtils utils = new JspUtils();
            this.pageContext.getOut().write(this.fuzzy ? this.renderFuzzyLayout() : utils.age(birth.getTime(), now.getTime()));
            return 6;
        }
        catch (IOException e2) {
            throw new JspException((Throwable)e2);
        }
        catch (DbException e3) {
            throw new JspException((Throwable)e3);
        }
    }

    private String renderFuzzyLayout() throws DbException {
        TimeZone tz = this.user != null ? AppConfig.getUserTimeZone(this.user.getUsername()) : AppConfig.getUserTimeZone(this.request);
        return DateHelper.fuzzyAge(this.mBirth.getTime(), this.mNow.getTime(), tz, this.request.getLocale());
    }
}

