/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.atlassian.fecru.user.UserProfile;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.LinkerFactory;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.RegionListRenderer;
import com.cenqua.fisheye.syntax.RegionListRenderingVisitor;
import com.cenqua.fisheye.syntax.RegionListVisitor;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public abstract class AbstractRegionListTag
extends SimpleTagSupport {
    private boolean mEscapeHTML = true;
    private Integer tabWidth;
    private String mSpace = " ";
    private String mEol = " <br>";
    private int currentCol = 0;
    private boolean mPrintFirstSpaceAsSpace = false;
    private boolean printLastSpaceAsSpace = false;
    private boolean allowConsecutiveNewline = true;
    private boolean enableLinks = true;
    private boolean enableMarkup = true;
    private boolean lastWasCR = false;
    private boolean lastWasNL = false;
    private boolean lastWasSpace = false;

    public void setPrintFirstSpaceAsSpace(boolean printFirstSpaceAsSpace) {
        this.mPrintFirstSpaceAsSpace = printFirstSpaceAsSpace;
    }

    public void setPrintLastSpaceAsSpace(boolean printLastSpaceAsSpace) {
        this.printLastSpaceAsSpace = printLastSpaceAsSpace;
    }

    public void setSpace(String space) {
        this.mSpace = space;
    }

    public String getSpace() {
        return this.mSpace;
    }

    public void setEol(String eol) {
        this.mEol = eol;
    }

    public String getEol() {
        return this.mEol;
    }

    public void setEscapeHTML(boolean escapeHTML) {
        this.mEscapeHTML = escapeHTML;
    }

    public void setEnableLinks(boolean enableLinks) {
        this.enableLinks = enableLinks;
    }

    public boolean getEnableLinks() {
        return this.enableLinks;
    }

    public boolean isEnableMarkup() {
        return this.enableMarkup;
    }

    public void setEnableMarkup(boolean enableMarkup) {
        this.enableMarkup = enableMarkup;
    }

    protected void outputRegion(CharSequence chars, RegionList regions, int startOffset, int endOffset) throws IOException {
        RegionList subregions = regions.getSubset(startOffset, endOffset);
        Writer out = this.getOut();
        subregions.visitRegions(this.getRegionVisitor(chars, out, startOffset, endOffset));
    }

    protected RegionListVisitor getRegionVisitor(CharSequence chars, Writer out, int startOffset, int endOffset) {
        return new RegionListRenderingVisitor(startOffset, endOffset, out, chars, this.getRegionRenderer());
    }

    protected RegionListRenderer getRegionRenderer() {
        return new RegionListRenderer(){
            private int hrefDepth = 0;

            @Override
            public boolean renderRegionStart(Region region, Writer writer) throws IOException {
                boolean hasRenderedOutput = false;
                if (AbstractRegionListTag.this.isEnableMarkup()) {
                    String type = AbstractRegionListTag.this.getSpanClass(region);
                    if (type != null && this.hrefDepth == 0) {
                        writer.write("<span class=\"" + type + "\">");
                        hasRenderedOutput = true;
                    }
                    String href = region.getPropertyValue("href");
                    if (AbstractRegionListTag.this.getEnableLinks() && href != null) {
                        if (this.hrefDepth == 0) {
                            writer.write("<a href=\"" + href + "\">");
                            hasRenderedOutput = true;
                        }
                        ++this.hrefDepth;
                    }
                }
                return hasRenderedOutput;
            }

            @Override
            public boolean renderRegionEnd(Region region, Writer writer) throws IOException {
                boolean hasRenderedOutput = false;
                if (AbstractRegionListTag.this.isEnableMarkup()) {
                    String type = AbstractRegionListTag.this.getSpanClass(region);
                    String href = region.getPropertyValue("href");
                    if (AbstractRegionListTag.this.getEnableLinks() && href != null) {
                        --this.hrefDepth;
                        if (this.hrefDepth == 0) {
                            writer.write("</a>");
                            hasRenderedOutput = true;
                        }
                    }
                    if (type != null && this.hrefDepth == 0) {
                        writer.write("</span>");
                        hasRenderedOutput = true;
                    }
                }
                return hasRenderedOutput;
            }

            @Override
            public void renderUpToRegionStart(Region region, Writer out, CharSequence chars) throws IOException {
                AbstractRegionListTag.this.format(out, chars);
            }

            @Override
            public void renderUpToRegionEnd(Region region, Writer out, CharSequence chars) throws IOException {
                AbstractRegionListTag.this.format(out, chars);
            }

            @Override
            public void renderEnd(Writer writer, CharSequence charSequence) throws IOException {
                AbstractRegionListTag.this.format(writer, charSequence);
            }
        };
    }

    protected Writer getOut() {
        return this.getJspContext().getOut();
    }

    protected abstract String getSpanClass(Region var1);

    protected String getStandardSpanClass(Region region, boolean isFrom) {
        String link = LinkerFactory.getPopupLinkSpanClass(region);
        if (link != null) {
            return link;
        }
        String type = region.getPropertyValue("type");
        if (type != null) {
            return "hl_" + type;
        }
        if (region.getPropertyValue("ediff") != null) {
            return isFrom ? "ediffChangedA" : "ediffChangedB";
        }
        return null;
    }

    protected void format(Writer out, CharSequence text) throws IOException {
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c2 = text.charAt(i2);
            boolean wasCR = false;
            boolean wasSpace = false;
            boolean wasNL = false;
            if (c2 == ' ') {
                boolean writeRealSpace = false;
                if (this.mPrintFirstSpaceAsSpace) {
                    boolean bl = writeRealSpace = !this.lastWasSpace;
                }
                if (this.printLastSpaceAsSpace) {
                    boolean bl = writeRealSpace = i2 + 1 >= text.length() || text.charAt(i2 + 1) != ' ';
                }
                if (!this.mPrintFirstSpaceAsSpace && this.currentCol == 0) {
                    writeRealSpace = false;
                }
                if (writeRealSpace) {
                    out.write(32);
                } else {
                    out.write(this.mSpace);
                }
                ++this.currentCol;
                wasSpace = true;
            } else if (c2 == '\t') {
                out.write(this.mSpace);
                ++this.currentCol;
                while (this.currentCol % this.tabWidth() != 0) {
                    out.write(this.mSpace);
                    ++this.currentCol;
                }
                wasSpace = true;
            } else if (c2 == '\r') {
                out.write(this.mEol);
                this.currentCol = 0;
                wasCR = true;
            } else if (c2 == '\n') {
                if (!(this.lastWasCR || this.lastWasNL && !this.allowConsecutiveNewline)) {
                    out.write(this.mEol);
                    this.currentCol = 0;
                }
                wasNL = true;
            } else {
                if (this.mEscapeHTML) {
                    ExpressionUtil.escapeChar(c2, out);
                } else {
                    out.write(c2);
                }
                ++this.currentCol;
            }
            this.lastWasCR = wasCR;
            this.lastWasNL = wasNL;
            this.lastWasSpace = wasSpace;
        }
    }

    public void resetLine() {
        this.currentCol = 0;
        this.lastWasCR = false;
        this.lastWasSpace = false;
    }

    private int tabWidth() {
        if (this.tabWidth == null) {
            this.tabWidth = this.defaultTabWidth();
        }
        return this.tabWidth;
    }

    private int defaultTabWidth() {
        try {
            UserLogin user;
            JspContext ctx;
            UserManager um = AppConfig.getsConfig().getUserManager();
            if (um != null && (ctx = this.getJspContext()) != null && (user = um.getCurrentUser(ctx)) != null) {
                UserProfile profile = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                return profile.getTabwidth();
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.info((Object)"problem getting tab width");
        }
        return AppConfig.DEFAULT_TAB_WIDTH;
    }

    public void setAllowConsecutiveNewline(boolean allowConsecutiveNewline) {
        this.allowConsecutiveNewline = allowConsecutiveNewline;
    }

    public boolean isAllowConsecutiveNewline() {
        return this.allowConsecutiveNewline;
    }
}

