/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import java.io.IOException;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class AbbreviatePathTag
extends SimpleTagSupport {
    private String pathString;
    private String separator = "/";
    private String spanTag = "<span>";

    public void doTag() throws JspException, IOException {
        this.getJspContext().getOut().print(this.abbreviatePathFormatted());
    }

    public void setPathString(String pathString) {
        this.pathString = pathString;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setClassName(String className) {
        this.spanTag = "<span class=\"" + className + "\">";
    }

    public String abbreviatePathFormatted() throws JspException {
        String[] components = this.pathString.split("(?<=[^<])" + this.separator + "(?=.)");
        Pattern tagPattern = Pattern.compile("<[^>]+>");
        Pattern tagStartPattern = Pattern.compile("<[^/>][^>]*(?!/)>");
        Pattern tagEndPattern = Pattern.compile("</[^>]+>");
        LinkedList<String> tagStartStack = new LinkedList<String>();
        LinkedList<String> tagEndStack = new LinkedList<String>();
        StringBuilder formattedPath = new StringBuilder();
        for (int i2 = 0; i2 < components.length; ++i2) {
            formattedPath.append(this.spanTag);
            for (String tagStart : tagStartStack) {
                formattedPath.append(tagStart);
            }
            String current = components[i2];
            Matcher tagMatcher = tagPattern.matcher(current);
            while (tagMatcher.find()) {
                String tag = tagMatcher.group(0);
                if (tagStartPattern.matcher(tag).matches()) {
                    tagStartStack.addLast(tag);
                    tagEndStack.addLast(tag.replaceFirst("<\\s*(\\w+).*>", "</$1>"));
                    continue;
                }
                if (tagEndPattern.matcher(tag).matches()) {
                    tagStartStack.removeLast();
                    tagEndStack.removeLast();
                    continue;
                }
                throw new JspException("AbbreviatePathTag: Malformed html tag: " + tag);
            }
            int beforeHalfIndex = components.length / 2;
            if (i2 < beforeHalfIndex) {
                formattedPath.append(current).append(this.separator);
            } else if (i2 == beforeHalfIndex) {
                formattedPath.append(current);
            } else {
                formattedPath.append(this.separator).append(current);
            }
            for (String tagEnd : tagEndStack) {
                formattedPath.append(tagEnd);
            }
            formattedPath.append("</span>");
        }
        return formattedPath.toString();
    }
}

