/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.soy;

import com.atlassian.applinks.host.OsgiServiceProxyFactory;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.cenqua.fisheye.web.soy.SoyRenderer;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="soyRenderer")
public class DefaultSoyRenderer
implements SoyRenderer {
    private final SoyTemplateRenderer soyTemplateRendererProxy;

    @Autowired
    public DefaultSoyRenderer(OsgiContainerManager osgiContainerManager) {
        this.soyTemplateRendererProxy = (SoyTemplateRenderer)new OsgiServiceProxyFactory(osgiContainerManager).createProxy(SoyTemplateRenderer.class, 10000L);
    }

    @Override
    public String render(String moduleKey, String templateName, Map<String, Object> data) throws SoyException {
        try {
            return this.soyTemplateRendererProxy.render(moduleKey, templateName, data);
        }
        catch (OsgiServiceProxyFactory.ServiceTimeoutExceeded e2) {
            return "Error rendering soy template, timed out finding SoyTemplateRenderer service in OSGi.";
        }
    }
}

