/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.setup;

import com.atlassian.crucible.actions.admin.database.MigrateDatabaseAction;
import com.cenqua.crucible.hibernate.AdminOperator;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.fisheye.config.SpringContext;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MigrateDBProgressServlet
extends HttpServlet {
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean failed;
        boolean finished;
        DBControlFactory dbControlFactory = (DBControlFactory)SpringContext.getComponent("dbControlFactory");
        AdminOperator op = dbControlFactory.getAdminOperator();
        if (!Objects.equals(req.getSession().getAttribute(MigrateDatabaseAction.MIGRATION_PROGRESS_SESSION_KEY), System.identityHashCode(op))) {
            resp.sendError(403, "You can't access this resource");
            return;
        }
        String status = "";
        if (op != null && op instanceof MigrateDatabaseAction.AsynchronousMigrater) {
            MigrateDatabaseAction.AsynchronousMigrater migrator = (MigrateDatabaseAction.AsynchronousMigrater)op;
            finished = migrator.isDone();
            failed = finished ? !migrator.isSuccess() : false;
            status = migrator.getStatusMessage();
            req.setAttribute("sourceDBControl", (Object)migrator.getSourceDBControl());
            req.setAttribute("targetDBControl", (Object)migrator.getTargetDBControl());
        } else {
            finished = true;
            failed = true;
        }
        if (finished) {
            dbControlFactory.setAdminOperator(null);
        }
        req.setAttribute("statusMessage", (Object)status);
        req.setAttribute("finished", (Object)finished);
        req.setAttribute("failed", (Object)failed);
        req.getRequestDispatcher("/WEB-INF/jsp/admin/migrateprogressajax.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }
}

