/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.security;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.WithSession;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.LoginCookieToken;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.security.BasicRfc2617Authenticator;
import com.cenqua.fisheye.web.security.UserDetector;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="userDetector")
public class DefaultUserDetector
implements UserDetector {
    private static final String ALREADY_PROCESSED = DefaultUserDetector.class.getName() + ".ALREADYPROCESSED";
    private final UserManager userManager;

    @Autowired
    public DefaultUserDetector(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    @WithSession
    public UserLogin process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LicensePolicyException {
        UserLogin user;
        boolean alreadyProcessed;
        boolean bl = alreadyProcessed = request.getAttribute(ALREADY_PROCESSED) != null;
        if (!alreadyProcessed) {
            request.setAttribute(ALREADY_PROCESSED, (Object)"yes");
        }
        if (alreadyProcessed) {
            user = this.userManager.getCurrentUser(request);
        } else {
            user = this.userManager.validateCurrentUser(request, response);
            if (user != null) {
                FecruUser feUser = null;
                try {
                    feUser = this.userManager.getLicensedUser(user.getUsername());
                }
                catch (DbException e2) {
                    Logs.APP_LOG.error((Object)e2.getMessage());
                }
                if (feUser != null) {
                    user.resetDisplayName(feUser.getDisplayName());
                }
            }
        }
        if (user != null) {
            request.setAttribute("feuser", (Object)user);
            return user;
        }
        if (alreadyProcessed) {
            return null;
        }
        user = DefaultUserDetector.getUser(request, response);
        if (user != null) {
            request.removeAttribute(UserManager.LOGIN_ERROR);
        }
        return user;
    }

    private static UserLogin getUser(HttpServletRequest request, HttpServletResponse response) throws LicensePolicyException {
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserLogin user = DefaultUserDetector.tryTrustedApplicationsLogin(request, response, um);
        if (user != null) {
            request.setAttribute("feuser", (Object)user);
            return user;
        }
        user = DefaultUserDetector.tryRequestDelegatedLogin(request, response, um);
        if (user != null) {
            return DefaultUserDetector.validateCurrentUser(request, response, um, user);
        }
        user = DefaultUserDetector.tryRememberMeLogin(request, response, um);
        if (user != null) {
            return DefaultUserDetector.validateCurrentUser(request, response, um, user);
        }
        user = DefaultUserDetector.tryPreCookedUrlLogin(request, response, um);
        if (user != null) {
            return DefaultUserDetector.validateCurrentUser(request, response, um, user);
        }
        user = DefaultUserDetector.tryBasicAuthentication(request, response, um);
        if (user != null) {
            return DefaultUserDetector.validateCurrentUser(request, response, um, user);
        }
        return null;
    }

    private static UserLogin validateCurrentUser(HttpServletRequest request, HttpServletResponse response, UserManager um, UserLogin user) {
        request.setAttribute("feuser", (Object)user);
        return um.validateCurrentUser(request, response);
    }

    private static UserLogin tryBasicAuthentication(HttpServletRequest request, HttpServletResponse response, UserManager um) {
        BasicRfc2617Authenticator authenticator = new BasicRfc2617Authenticator(request);
        if (authenticator.containsUsernamePassword()) {
            try {
                UserLogin user = um.login(request, response, authenticator.getUsername(), authenticator.getPassword(), false);
                if (user == null && request.getAttribute(UserManager.LOGIN_ERROR) == null) {
                    request.setAttribute(UserManager.LOGIN_ERROR, (Object)UserManager.LoginError.BASIC_AUTH_INVALID);
                }
                return user;
            }
            catch (Exception e2) {
                Logs.APP_LOG.debug((Object)"", (Throwable)e2);
            }
        }
        return null;
    }

    private static UserLogin tryTrustedApplicationsLogin(HttpServletRequest request, HttpServletResponse response, UserManager um) {
        return (UserLogin)request.getAttribute("fisheye.trusted.apps.user.login");
    }

    private static UserLogin tryRequestDelegatedLogin(HttpServletRequest request, HttpServletResponse response, UserManager um) throws LicensePolicyException {
        try {
            return um.tryRequestDelegatedLogin(request, response);
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"problem logging user delegated ", (Throwable)e2);
            return null;
        }
    }

    private static UserLogin tryPreCookedUrlLogin(HttpServletRequest request, HttpServletResponse response, UserManager um) {
        String tok = request.getParameter("FEAUTH");
        if (tok == null) {
            return null;
        }
        UserLogin user = DefaultUserDetector.tryTokenLogin(tok, request, response, um);
        if (user == null && request.getAttribute(UserManager.LOGIN_ERROR) == null) {
            request.setAttribute(UserManager.LOGIN_ERROR, (Object)UserManager.LoginError.FEAUTH_TOKEN_INVALID);
        }
        return user;
    }

    private static UserLogin tryRememberMeLogin(HttpServletRequest request, HttpServletResponse response, UserManager um) {
        Cookie c2 = DefaultUserDetector.getPersistentCookie(request);
        if (c2 == null || c2.getValue() == null) {
            return null;
        }
        UserLogin user = DefaultUserDetector.tryTokenLogin(c2.getValue(), request, response, um);
        if (user == null) {
            c2.setMaxAge(0);
            response.addCookie(c2);
        }
        return user;
    }

    private static UserLogin tryTokenLogin(String value, HttpServletRequest request, HttpServletResponse response, UserManager um) {
        LoginCookieToken given = LoginCookieToken.decode(value);
        if (given == null) {
            return null;
        }
        try {
            return um.login(request, response, given);
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"problem logging in remembered user via a cookie", (Throwable)e2);
            return null;
        }
    }

    private static Cookie getPersistentCookie(HttpServletRequest req) {
        try {
            Cookie[] cookies = req.getCookies();
            if (cookies == null) {
                return null;
            }
            for (int i2 = 0; i2 < cookies.length; ++i2) {
                Cookie c2 = cookies[i2];
                if (!"remember".equals(c2.getName())) continue;
                return c2;
            }
            return null;
        }
        catch (NumberFormatException e2) {
            Enumeration en = req.getHeaders("Cookie");
            while (en.hasMoreElements()) {
                String cookie = (String)en.nextElement();
                Logs.APP_LOG.error((Object)("Cookie parsing error for request path: " + req.getServletPath() + "Cookie header: " + cookie));
            }
            throw e2;
        }
    }
}

