/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.security;

import com.atlassian.fecru.security.RequirePrivilegedUser;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.RestApiKeyType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.security.RestApiKeyManager;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class DefaultRestApiKeyManager
implements RestApiKeyManager {
    @Resource
    private EffectiveUserProvider effectiveUserProvider;

    @Override
    @RequirePrivilegedUser
    public void generateApiKey() throws IOException {
        SecurityType security = this.getSecurity();
        RestApiKeyType apiKey = RestApiKeyType.Factory.newInstance();
        apiKey.setApiKey(DefaultSecureTokenGenerator.getInstance().generateToken());
        apiKey.setGenerationDate(Calendar.getInstance());
        security.setRestApiKey(apiKey);
        this.saveConfig();
        Logs.APP_LOG.info((Object)("New REST API token generated by " + this.getUsername()));
    }

    @Override
    @RequirePrivilegedUser
    public void deleteApiKey() throws IOException {
        SecurityType security = this.getSecurity();
        if (security.isSetRestApiKey()) {
            security.unsetRestApiKey();
        }
        this.saveConfig();
        Logs.APP_LOG.info((Object)("REST API token deleted by " + this.getUsername()));
    }

    @Override
    @RequirePrivilegedUser
    @Nullable
    public String getRestApiKey() {
        return this.getKeyInner();
    }

    @Override
    @RequirePrivilegedUser
    @Nullable
    public Date getRestApiKeyGenerationDate() {
        return this.getSecurity().isSetRestApiKey() ? this.getSecurity().getRestApiKey().getGenerationDate().getTime() : null;
    }

    @Override
    public boolean isValidKey(String token) {
        if (token == null || token.isEmpty()) {
            return false;
        }
        return token.equals(this.getKeyInner());
    }

    private String getUsername() {
        FecruUser effectiveUser = this.effectiveUserProvider.getEffectiveUser();
        return effectiveUser == null ? "anonymous admin user" : effectiveUser.getUsername();
    }

    private SecurityType getSecurity() {
        return AppConfig.getsConfig().getConfig().getSecurity();
    }

    private void saveConfig() throws IOException {
        AppConfig.getsConfig().saveConfig();
    }

    private String getKeyInner() {
        return this.getSecurity().isSetRestApiKey() ? this.getSecurity().getRestApiKey().getApiKey() : null;
    }
}

