/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.security;

import com.atlassian.security.random.DefaultSecureRandomService;
import com.atlassian.security.random.SecureRandomService;
import com.cenqua.fisheye.util.StringUtil;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.DefaultManageableImageCaptchaService;
import java.awt.image.BufferedImage;
import java.util.Locale;

public class CaptchaManager {
    private static final SecureRandomService RANDOM = DefaultSecureRandomService.getInstance();
    private static final CaptchaManager INSTANCE;
    private final DefaultManageableImageCaptchaService captcha = new DefaultManageableImageCaptchaService();

    public static CaptchaManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeCaptchaId() {
        int nRandom = 16;
        byte[] b2 = new byte[16];
        SecureRandomService secureRandomService = RANDOM;
        synchronized (secureRandomService) {
            RANDOM.nextBytes(b2);
        }
        return StringUtil.hexEncode(b2);
    }

    public BufferedImage getImageChallengeForID(String id, Locale locale) throws CaptchaServiceException {
        return this.captcha.getImageChallengeForID(id, locale);
    }

    public Boolean validateResponseForID(String id, String response) throws CaptchaServiceException {
        return this.captcha.validateResponseForID(id, (Object)response);
    }

    static {
        RANDOM.nextBytes(new byte[1]);
        INSTANCE = new CaptchaManager();
    }
}

