/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.security;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;

public class BasicRfc2617Authenticator {
    private final String password;
    private final String username;
    private final boolean hasUsernameAndPassword;

    public BasicRfc2617Authenticator(HttpServletRequest request) {
        this(request.getHeader("Authorization"));
    }

    public BasicRfc2617Authenticator(String header) {
        int delim;
        String token = this.decodeToken(header);
        if (token != null && (delim = token.indexOf(":")) != -1) {
            this.username = token.substring(0, delim);
            this.password = token.substring(delim + 1);
            this.hasUsernameAndPassword = true;
        } else {
            this.username = "";
            this.password = "";
            this.hasUsernameAndPassword = false;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean containsUsernamePassword() {
        return this.hasUsernameAndPassword;
    }

    private String decodeToken(String authorizationHeader) {
        if (authorizationHeader != null && authorizationHeader.startsWith("Basic ")) {
            String base64Token = authorizationHeader.substring(6);
            byte[] base64Bytes = base64Token.getBytes();
            if (!Base64.isArrayByteBase64((byte[])base64Bytes)) {
                return null;
            }
            return new String(Base64.decodeBase64((byte[])base64Bytes));
        }
        return null;
    }
}

