/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.profile.actions;

import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.util.FisheyeEmailValidator;
import com.google.common.base.Strings;
import com.opensymphony.xwork.ActionSupport;

public class ExternalUserHelper {
    private final UserManager userManager;
    private final String username;
    private static final String USER_DISPLAY_NAME_FIELD = "userDisplayName";
    private static final String USER_EMAIL_FIELD = "userEmail";
    private static final int MAX_LENGTH = 255;

    public ExternalUserHelper(String username, UserManager userManager) {
        this.username = username;
        this.userManager = userManager;
    }

    public void validateUserFields(ActionSupport action, String email, String displayName) {
        if (!this.isUserNotUpdatable()) {
            ExternalUserHelper.checkValidEmail(action, email);
            ExternalUserHelper.checkValidDisplayName(action, displayName);
        }
    }

    private static void checkValidEmail(ActionSupport action, String email) {
        if (!Strings.isNullOrEmpty((String)email)) {
            FisheyeEmailValidator validator = new FisheyeEmailValidator();
            if (!validator.isValid(email)) {
                action.addFieldError(USER_EMAIL_FIELD, "The provided email address is invalid");
            }
        } else {
            action.addFieldError(USER_EMAIL_FIELD, "A value must be provided for email address");
        }
    }

    private static void checkValidDisplayName(ActionSupport action, String displayName) {
        if (!Strings.isNullOrEmpty((String)displayName)) {
            if (displayName.length() > 255) {
                action.addFieldError(USER_DISPLAY_NAME_FIELD, "Display name must be 255 characters or less.");
            }
        } else {
            action.addFieldError(USER_DISPLAY_NAME_FIELD, "A value must be provided for display name");
        }
    }

    public boolean isUserNotUpdatable() {
        return !this.userManager.canUpdateUser(this.username);
    }
}

