/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.profile.actions;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fisheye.gravatar.AvatarManager;
import com.atlassian.fisheye.spi.services.ServerInfoService;
import com.atlassian.fisheye.stars.tags.StarData;
import com.atlassian.fisheye.stars.tags.StarWebUtil;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.config.ConfigParameters;
import com.cenqua.fisheye.config.ConfigUtil;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.Auth;
import com.cenqua.fisheye.user.AuthTok;
import com.cenqua.fisheye.user.AuthenticationException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.profile.actions.AbstractProfileAction;
import com.cenqua.fisheye.web.profile.actions.ExternalUserHelper;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class EditUserSettingsAction
extends AbstractProfileAction {
    public static final String DEFAULT_SERVER_TIMEZONE_VALUE = "--default-server-timezone--";
    private CookiePreferences prefs;
    private List watches = Collections.EMPTY_LIST;
    private int watchID = -1;
    private String email;
    private String displayName;
    private File avatar;
    private String avatarContentType;
    private String password;
    private static final int MAX_STAR_NUM = 20;
    private List<StarData> allStars;
    private Map<String, String> preferencesToSet = new HashMap<String, String>();
    @Autowired
    private ConfigParameters configParameters;
    @Autowired
    private AvatarManager avatarManager;
    @Autowired
    private RootConfig rootConfig;
    @Autowired
    private UserManager userManager;
    @Autowired
    private ServerInfoService serverInfoService;
    private ExternalUserHelper externalUserHelper;
    private String timezone;

    public ExternalUserHelper getExternalUserHelper() {
        if (this.externalUserHelper == null) {
            this.externalUserHelper = new ExternalUserHelper(this.getUserLogin().getUsername(), this.userManager);
        }
        return this.externalUserHelper;
    }

    public int getWatchID() {
        return this.watchID;
    }

    public void setWatchID(int watchID) {
        this.watchID = watchID;
    }

    public List getWatches() {
        return this.watches;
    }

    public CookiePreferences getPrefs() {
        return this.prefs;
    }

    public Collection getTimezones() {
        return DateHelper.AVAILABLE_TIMEZONE_IDS;
    }

    public String getDefaultTimezone() {
        return ConfigUtil.getDefaultTimezone();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSavedEmail() {
        FecruUser user = this.getCurrentUser();
        if (user != null) {
            return user.getEmail();
        }
        return null;
    }

    public boolean getConfirmationRequired() {
        boolean canModifyDetails = this.userManager.canUpdateUser(this.getCurrentUser().getUsername());
        boolean noPasswords = this.userManager.isPasswordlessAuthenticationEnabled();
        return canModifyDetails && !noPasswords;
    }

    public String getProductName() {
        return this.serverInfoService.getProductName();
    }

    public void setViewMode(String viewMode) {
        this.preferencesToSet.put(CookiePreferences.Pref.VIEW_MODE.name, viewMode);
    }

    public void setAlwaysExpandChangesets(String alwaysExpandChangesets) {
        this.preferencesToSet.put(CookiePreferences.Pref.ALWAYS_EXPAND_CHANGESETS.name, alwaysExpandChangesets);
    }

    public void setDiffMode(String diffMode) {
        this.preferencesToSet.put(CookiePreferences.Pref.DIFF_MODE.name, diffMode);
    }

    public void setDiffWrap(String diffWrap) {
        this.preferencesToSet.put(CookiePreferences.Pref.DIFF_WRAP.name, diffWrap);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setAvatar(File avatar) {
        this.avatar = avatar;
    }

    public File getAvatar() {
        return this.avatar;
    }

    public void setAvatarContentType(String avatarContentType) {
        this.avatarContentType = avatarContentType != null ? avatarContentType.toLowerCase(Locale.US) : null;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String execute() throws Exception {
        this.prefs = PreferenceManager.getPreferences(this.request);
        this.setPreferencesFromRequest();
        this.profile.setCookiePrefs(this.prefs.asCookieValue());
        UserLogin userLogin = this.getUserLogin();
        try {
            if (userLogin != null) {
                this.configChangePasswordEnabled(userLogin.getUserName());
                UserProfile current = this.userProfileManager.getProfile(userLogin.getUserName());
                this.profile.setWatchMode(current.getWatchMode());
                this.profile.setEmailFormat(current.getEmailFormat());
                if (StringUtils.isNotBlank((String)this.timezone)) {
                    this.profile.setTimezone(DEFAULT_SERVER_TIMEZONE_VALUE.equals(this.timezone) ? null : this.timezone);
                }
                this.userProfileManager.setProfile(userLogin.getUserName(), this.profile);
                return "success";
            }
            this.addActionError("User not found");
        }
        catch (DbException e2) {
            this.handleException("Database error loading user profile", e2);
        }
        return "error";
    }

    private void setPreferencesFromRequest() {
        if (!this.preferencesToSet.isEmpty()) {
            for (Map.Entry<String, String> entry : this.preferencesToSet.entrySet()) {
                this.prefs.putValue(entry.getKey(), entry.getValue());
            }
        }
        if (this.prefs.isChanged()) {
            PreferenceManager.setPreferences(this.prefs, this.request, this.response);
        }
    }

    private FecruUser getCurrentUser() {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            return this.userManager.getUser(user.getUsername());
        }
        return null;
    }

    public void validate() {
        this.getExternalUserHelper().validateUserFields(this, this.email, this.displayName);
        if (this.hasErrors()) {
            return;
        }
        this.validateEmailChangeIsPasswordProtected();
        this.validateEmailIsUnique();
    }

    private void validateEmailChangeIsPasswordProtected() {
        FecruUser user = this.getCurrentUser();
        if (this.getConfirmationRequired() && !Strings.isNullOrEmpty((String)this.email) && !this.email.equals(user.getEmail())) {
            String username = user.getUsername();
            Auth authenticationProvider = this.userManager.getAuthenticationProvider();
            try {
                AuthTok token = authenticationProvider.authenticate(username, this.password, null, null);
                if (token == null) {
                    this.handlePasswordConfirmationFailure();
                }
            }
            catch (AuthenticationException e2) {
                this.handlePasswordConfirmationFailure();
            }
        }
    }

    private void validateEmailIsUnique() {
        String existingUser;
        FecruUser user = this.getCurrentUser();
        if (!Strings.isNullOrEmpty((String)this.email) && !this.email.equals(user.getEmail()) && (existingUser = this.userManager.getUsernameByEmail(this.email)) != null) {
            this.addFieldError("email", this.getText("email.already.used.msg"));
        }
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        this.prefs = PreferenceManager.getPreferences(this.request);
        UserLogin userLogin = this.getUserLogin();
        try {
            if (userLogin != null) {
                this.configChangePasswordEnabled(userLogin.getName());
                this.profile = this.userProfileManager.getProfile(userLogin.getName());
                this.timezone = this.profile.getTimezone();
                return "success";
            }
            this.addActionError("User not found");
        }
        catch (DbException e2) {
            this.handleException("Database error loading user profile", e2);
        }
        return "error";
    }

    @RequireSecurityToken(value=false)
    public String loadEmail() {
        if (this.getUserLogin() != null) {
            try {
                FecruUser user = this.getCurrentUser();
                this.configChangePasswordEnabled(user.getUsername());
                this.email = user.getEmail();
                this.displayName = user.getDisplayName();
                this.profile = this.userProfileManager.getProfile(user.getUsername());
                return "success";
            }
            catch (DbException e2) {
                this.handleException("Database error loading user profile", e2);
            }
        } else {
            this.addActionError("User not found");
        }
        return "error";
    }

    private void handleException(String msg, Exception e2) {
        Logs.APP_LOG.warn((Object)String.format("%s : ", msg), (Throwable)e2);
        this.addActionError(msg);
    }

    private void handlePasswordConfirmationFailure() {
        this.addFieldError("password", this.getText("password.confirmation.failure.msg"));
    }

    public String updateEmail() {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            try {
                FecruUser local = this.getCurrentUser();
                this.configChangePasswordEnabled(local.getUsername());
                if (this.userManager.canUpdateUser(local.getUsername())) {
                    this.userManager.updateUser(local.getUsername(), this.displayName, this.email);
                }
            }
            catch (Exception e2) {
                this.handleException("Database error updating user settings", e2);
                return "error";
            }
            try {
                UserProfile userProf = this.userProfileManager.getProfile(user.getUsername());
                userProf.setEmailFormat(this.profile.getEmailFormat());
                this.userProfileManager.setProfile(user.getUsername(), userProf);
                this.profile = userProf;
                return "success";
            }
            catch (Exception e3) {
                this.handleException("Database error updating user profile", e3);
            }
        } else {
            this.addActionError("User not found");
        }
        return "error";
    }

    @RequireSecurityToken(value=false)
    public String loadFavourites() {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            this.allStars = StarWebUtil.getLoggedInUsersStars(user);
            return "success";
        }
        this.addActionError("User not found");
        return "error";
    }

    public List<StarData> getAllStars() {
        return this.allStars;
    }

    public int getNumStars() {
        return this.allStars.size();
    }

    public List<StarData> getTopStars() {
        return this.allStars.subList(0, Math.min(this.allStars.size(), 20));
    }

    @RequireSecurityToken(value=false)
    public String loadWatches() {
        if (!this.rootConfig.isFishEye()) {
            return "404";
        }
        UserLogin user = this.getUserLogin();
        if (user != null) {
            try {
                this.watches = this.rootConfig.getWatchManager().getWatchesForUser(user.getUsername());
                if (Logs.APP_LOG.isDebugEnabled()) {
                    Logs.APP_LOG.debug((Object)String.format("Loaded watches for user[%s]: %s", user.getUsername(), Arrays.toString(this.watches.toArray())));
                }
            }
            catch (DbException e2) {
                this.handleException("Database error loading user watches", e2);
                return "error";
            }
            try {
                FecruUser feu = this.getCurrentUser();
                this.configChangePasswordEnabled(feu.getUsername());
                this.email = feu.getEmail();
            }
            catch (DbException e3) {
                this.handleException("Database error loading user information", e3);
                return "error";
            }
            try {
                this.profile = this.userProfileManager.getProfile(user.getUsername());
            }
            catch (DbException e4) {
                this.handleException("Database error loading profile", e4);
                return "error";
            }
            return "success";
        }
        this.addActionError("User not found");
        return "error";
    }

    public String updateWatchSettings() {
        if (!this.rootConfig.isFishEye()) {
            return "404";
        }
        UserLogin user = this.getUserLogin();
        if (user != null) {
            try {
                this.configChangePasswordEnabled(user.getUsername());
                UserProfile userProf = this.userProfileManager.getProfile(user.getUsername());
                userProf.setWatchMode(this.profile.getWatchMode());
                this.userProfileManager.setProfile(user.getUsername(), userProf);
                this.profile = userProf;
                return "success";
            }
            catch (DbException e2) {
                this.handleException("Database error updating profile", e2);
            }
        } else {
            this.addActionError("User not found");
        }
        return "error";
    }

    public String deleteWatch() {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            try {
                FecruUser feu = this.getCurrentUser();
                this.configChangePasswordEnabled(user.getUsername());
                if (this.rootConfig.getWatchManager().deleteWatch(this.watchID)) {
                    Logs.APP_LOG.debug((Object)String.format("Deleted watch[id:%d]", this.watchID));
                    PreferenceManager.touchCookie(this.request, this.response);
                    this.email = feu.getEmail();
                    return this.loadWatches();
                }
            }
            catch (DbException e2) {
                this.handleException(String.format("Database error deleting watch '%d'", this.watchID), e2);
            }
        } else {
            this.addActionError("User not found");
        }
        return "error";
    }

    private boolean hasCorrectAvatarContentType() {
        return this.avatarContentType != null && this.avatarManager.getPermittedContentTypes().contains(this.avatarContentType);
    }

    public String uploadAvatar() {
        if (this.avatar != null && this.hasCorrectAvatarContentType()) {
            try {
                this.avatarManager.saveAvatar(this.getUser(), this.avatar);
            }
            catch (IOException e2) {
                if ("Unexpected block type 0!".equals(e2.getMessage())) {
                    this.addFieldError("avatar", this.getText("avatar.ioe.gif.error.msg"));
                } else {
                    this.addFieldError("avatar", this.getText("avatar.unknown.error.msg"));
                }
                Logs.APP_LOG.debug((Object)"An error occurred while uploading an avatar", (Throwable)e2);
                this.loadEmail();
                return "error";
            }
            catch (IllegalStateException e3) {
                if ("Image file is corrupt".equals(e3.getMessage())) {
                    this.addFieldError("avatar", this.getText("avatar.ise.corrupt.error.msg"));
                } else {
                    this.addFieldError("avatar", this.getText("avatar.unknown.error.msg"));
                }
                Logs.APP_LOG.error((Object)"An error occurred while uploading an avatar", (Throwable)e3);
                this.loadEmail();
                return "error";
            }
            return "success";
        }
        HashMap errors = new HashMap(this.getFieldErrors());
        errors.put("avatar", new ArrayList());
        this.setFieldErrors(errors);
        this.addFieldError("avatar", this.getText("avatar.require.input.msg"));
        return "error";
    }

    public FecruUser getUser() {
        UserLogin userLogin = this.getUserLogin();
        if (userLogin == null) {
            return null;
        }
        return this.userManager.getUser(userLogin.getName());
    }

    @Override
    @ParameterSafe
    public UserProfile getProfile() throws DbException {
        return super.getProfile();
    }
}

