/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.profile.actions;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.model.CommitterUserMapping;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.web.profile.actions.AbstractProfileAction;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class EditAuthorMappingAction
extends AbstractProfileAction {
    @Autowired
    protected CommitterUserMappingManager manager;
    @Autowired
    private RepositoryManager repositoryManager;
    private Multimap<String, String> committerMappings = HashMultimap.create();
    private String rep;
    private Collection<String> committers;
    private String committer;
    private boolean confirmOverride = false;
    private boolean hasConfirmed = false;
    private Multimap<String, String> implicitMappings;

    public boolean getConfirmOverride() {
        return this.confirmOverride;
    }

    public void setConfirmOverride(boolean confirmOverride) {
        this.confirmOverride = confirmOverride;
    }

    public void setRep(String rep) {
        this.rep = rep;
    }

    public String getRep() {
        return this.rep;
    }

    public List<RepositoryHandle> getRepositories() {
        return RepositoryUtil.repositories(this.request);
    }

    public Set<String> getMappedReps() {
        return this.committerMappings.keySet();
    }

    public Set<String> getImplicitlyMappedReps() {
        return this.implicitMappings.keySet();
    }

    public Set<String> getVisableRunningReps() {
        TreeSet<String> results = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s2, String s1) {
                return s2.compareToIgnoreCase(s1);
            }
        });
        for (RepositoryHandle handle : this.getRepositories()) {
            if (!handle.isRunning()) continue;
            results.add(handle.getName());
        }
        return results;
    }

    public Collection<String> getMappedCommitters(String rep) {
        return this.committerMappings.get((Object)rep);
    }

    public Collection<String> getImplicitCommitters(String rep) {
        return this.implicitMappings.get((Object)rep);
    }

    public List<String> getCommittersMinusMine(String rep) throws DbException {
        List<String> all = new ArrayList<String>();
        RepositoryHandle handle = this.repositoryManager.getRepository(rep);
        if (handle == null) {
            return all;
        }
        all = RepositoryUtil.getCommittersInRep(handle);
        UserLogin user = this.getUserLogin();
        if (user != null) {
            this.committerMappings = this.manager.getExplicitCommittersForUser(user.getUserName());
            Collection mine = this.committerMappings.get((Object)rep);
            if (mine != null) {
                all.removeAll(mine);
            }
        }
        return all;
    }

    public String getSuggestedAuthor(String rep, String user) throws DbException {
        int bestDistance = Integer.MAX_VALUE;
        String best = null;
        RepositoryHandle handle = this.repositoryManager.getRepository(rep);
        if (handle == null) {
            return best;
        }
        for (String author : RepositoryUtil.getCommittersInRep(handle)) {
            int distance = EditAuthorMappingAction.editDistance(user, author);
            if (distance >= bestDistance) continue;
            bestDistance = distance;
            best = author;
        }
        return best;
    }

    public String deleteMapping() throws Exception {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            this.configChangePasswordEnabled(user.getUsername());
            this.manager.delete(user.getUserName(), this.rep, this.committer);
            return "success";
        }
        this.addActionError("User not found");
        return "error";
    }

    public String editMapping() {
        if (!AppConfig.getsConfig().getConfig().getSecurity().getAllowUserMapping()) {
            this.addActionError("User managed mappings are currently disabled. Please contact your system administrator");
            return "error";
        }
        UserLogin user = this.getUserLogin();
        if (user != null) {
            this.configChangePasswordEnabled(user.getUsername());
            this.committerMappings = this.manager.getExplicitCommittersForUser(user.getUserName());
            CommitterUserMapping existingMapping = this.manager.findByRepositoryAndCommitter(this.rep, this.committer);
            if (existingMapping != null) {
                Optional presupposedActive = Optional.fromNullable((Object)this.manager.getUserForCommitter(this.rep, this.committer));
                if (presupposedActive.isPresent() && !this.confirmOverride) {
                    this.hasConfirmed = true;
                    this.addActionError("Mapping already belongs to " + ((FecruUser)presupposedActive.get()).getDisplayName() + ". Click 'Add mapping' to override.");
                    return "input";
                }
                this.manager.updateMapping(existingMapping, new CommitterUserMapping(user.getUserName(), this.rep, this.committer));
            } else {
                this.manager.addMapping(user.getUserName(), this.rep, this.committer);
            }
            return "success";
        }
        this.addActionError("User not found");
        return "error";
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        UserLogin user = this.getUserLogin();
        try {
            if (user != null) {
                this.configChangePasswordEnabled(user.getUsername());
                this.committerMappings = this.manager.getExplicitCommittersForUser(user.getUserName());
                this.implicitMappings = this.manager.getImplicitCommittersForUser(user.getUserName());
                if (this.rep != null) {
                    this.committers = this.committerMappings.get((Object)this.rep);
                    if (this.committers == null) {
                        this.committers = Arrays.asList(this.getSuggestedAuthor(this.rep, user.getUserName()));
                    }
                }
                return "success";
            }
            this.addActionError("User not found");
        }
        catch (DbException e2) {
            this.addActionError("Database error loading user profile");
        }
        return "error";
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    public String getCommitter() {
        return this.committer;
    }

    public void setCommitters(Collection<String> committers) {
        this.committers = committers;
    }

    public boolean hasConfirmed() {
        return this.hasConfirmed;
    }

    private static int editDistance(CharSequence s2, CharSequence t2) {
        int j2;
        int i2;
        int n2 = s2.length();
        int m2 = t2.length();
        if (n2 == 0) {
            return m2;
        }
        if (m2 == 0) {
            return n2;
        }
        int[][] d2 = new int[n2 + 1][m2 + 1];
        for (i2 = 0; i2 <= n2; ++i2) {
            d2[i2][0] = i2;
        }
        for (j2 = 0; j2 <= m2; ++j2) {
            d2[0][j2] = j2;
        }
        for (i2 = 1; i2 <= n2; ++i2) {
            char s_i = s2.charAt(i2 - 1);
            for (j2 = 1; j2 <= m2; ++j2) {
                char t_j = t2.charAt(j2 - 1);
                int cost = s_i == t_j ? 0 : 1;
                d2[i2][j2] = NumberUtils.min((int)(d2[i2 - 1][j2] + 1), (int)(d2[i2][j2 - 1] + 1), (int)(d2[i2 - 1][j2 - 1] + cost));
            }
        }
        return d2[n2][m2];
    }
}

