/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.profile.actions;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.profile.actions.AbstractProfileAction;
import com.google.common.base.Strings;
import org.springframework.beans.factory.annotation.Autowired;

public class ChangePasswordAction
extends AbstractProfileAction {
    private String currentPassword;
    private String newPassword;
    private String confirmNewPassword;
    private boolean passwordChanged;

    @Autowired
    public ChangePasswordAction(UserManager userManager) {
        this.userManager = userManager;
    }

    public ChangePasswordAction() {
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            try {
                this.configChangePasswordEnabled(user.getUsername());
                return "success";
            }
            catch (DbException e2) {
                this.addActionError("Database error updating password");
            }
        } else {
            this.addActionError("User not found");
        }
        return "error";
    }

    public String execute() {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            try {
                this.configChangePasswordEnabled(user.getUsername());
                if (Strings.isNullOrEmpty((String)this.currentPassword)) {
                    this.addFieldError("currentPassword", "Please enter your current password");
                    return "input";
                }
                if (!this.userManager.isValidPassword(user.getUserName(), this.currentPassword)) {
                    this.addFieldError("currentPassword", "Incorrect password");
                    return "input";
                }
                if (Strings.isNullOrEmpty((String)this.newPassword)) {
                    this.addFieldError("newPassword", "Please enter a new password");
                    return "input";
                }
                if (Strings.isNullOrEmpty((String)this.confirmNewPassword)) {
                    this.addFieldError("confirmNewPassword", "Please confirm your new password by re-entering it");
                    return "input";
                }
                if (!this.newPassword.equals(this.confirmNewPassword)) {
                    this.addFieldError("confirmNewPassword", "The confirmed new password doesn't match new password");
                    return "input";
                }
                this.userManager.changePassword(user.getUsername(), this.newPassword);
                this.passwordChanged = true;
                return "success";
            }
            catch (DbException e2) {
                this.addActionError("Database error updating password");
            }
        } else {
            this.addActionError("User not found");
        }
        return "error";
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getConfirmNewPassword() {
        return this.confirmNewPassword;
    }

    public void setConfirmNewPassword(String confirmNewPassword) {
        this.confirmNewPassword = confirmNewPassword;
    }

    public boolean isPasswordChanged() {
        return this.passwordChanged;
    }

    public void setPasswordChanged(boolean passwordChanged) {
        this.passwordChanged = passwordChanged;
    }
}

