/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.profile.actions;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fisheye.jira.JiraServerService;
import com.cenqua.crucible.model.UserAppLink;
import com.cenqua.crucible.model.managers.UserAppLinkManager;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.Maps;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import com.opensymphony.xwork.ActionSupport;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractProfileAction
extends ActionSupport
implements ServletRequestAware,
ServletResponseAware {
    private boolean changePasswordEnabled = false;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected UserProfile profile;
    protected Map<String, String> ignoredJiraServers;
    @Autowired
    protected UserManager userManager;
    @Autowired
    protected UserProfileManager userProfileManager;
    @Autowired
    protected Mailer mailer;
    @Autowired
    private UserAppLinkManager userAppLinkManager;
    @Autowired
    private JiraServerService jiraServerService;

    public boolean isChangePasswordEnabled() {
        return this.changePasswordEnabled;
    }

    public boolean isMailerConfigured() {
        return this.mailer.isConfigured();
    }

    protected void configChangePasswordEnabled(String username) throws DbException {
        this.changePasswordEnabled = !this.userManager.isPasswordlessAuthenticationEnabled() && this.userManager.canUpdateUser(username);
    }

    protected UserLogin getUserLogin() {
        return this.userManager.getCurrentUser(this.request);
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public UserProfile getProfile() throws DbException {
        if (this.profile == null) {
            this.profile = this.userProfileManager.getProfile(this.getUserLogin().getUserName());
            if (this.profile == null) {
                this.profile = this.userProfileManager.getDefaultProfile();
            }
        }
        return this.profile;
    }

    public Map<String, String> getIgnoredJiraServers() {
        if (this.ignoredJiraServers == null) {
            this.ignoredJiraServers = Maps.newHashMap();
            List<UserAppLink> appLinks = this.userAppLinkManager.getUserAppLinks(this.profile.getUser());
            for (UserAppLink appLink : appLinks) {
                JiraServer jiraServer;
                if (!appLink.isIgnore() || (jiraServer = this.jiraServerService.getJiraServer(new ApplicationId(appLink.getAppLinkId()))) == null) continue;
                this.ignoredJiraServers.put(jiraServer.getApplicationLink().getName(), jiraServer.getDisplayUrl());
            }
        }
        return this.ignoredJiraServers;
    }
}

