/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.parameterbeans;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.UrlHelper;
import com.cenqua.fisheye.web.Watch;
import com.cenqua.fisheye.web.WatchManager;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.dirtree.FisheyeFileTableData;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.cenqua.fisheye.web.parameterbeans.BaseFishEyeServletParams;
import com.cenqua.fisheye.web.parameterbeans.Util;
import com.cenqua.fisheye.web.parameterbeans.WatchParams;
import com.cenqua.fisheye.web.tarball.TarballAction;

public class ViewRepositoryServletParams
extends BaseFishEyeServletParams {
    private String tarballNamePrefix;
    private Boolean tarballEnabled;
    private Boolean requiresAuth;
    private final WatchParams watchParams = new WatchParams();
    private String rssFeedUrl;

    public ViewRepositoryServletParams(RepositoryEngine engine, FisheyeRepositoryExplorer explorer, Path path, WaybackSpec wbSpec) {
        super(engine.getName(), PreferenceManager.getPreferences(CrucibleFilter.getRequest()));
        this.setFpath(new Path(new Path(engine.getName()), path));
        this.setPath(path);
        this.setWbSpec(wbSpec);
        this.setRequiresAuth(!AppConfig.getsConfig().getConfig().getSecurity().getAllowAnon() || !engine.getCfg().isAnonAccessAllowed());
        this.getWatchParams().setWatching(this.isWatching(path, engine.getName(), wbSpec));
        this.setTarballNamePrefix(TarballAction.makeTarballFilename(this.fpath));
        this.setRepositoryExplorer(explorer);
        this.setTarballEnabled(engine.getCfg().getTarballConfig().isEnabled() && !engine.getCfg().getTarballConfig().isExcluded(path));
    }

    public ViewRepositoryServletParams(BaseActionParams params) {
        super(params);
    }

    public String getTarballNamePrefix() {
        return this.tarballNamePrefix;
    }

    public Boolean getTarballEnabled() {
        return this.tarballEnabled;
    }

    public Boolean getRequiresAuth() {
        return this.requiresAuth;
    }

    public void setTarballNamePrefix(String tarballNamePrefix) {
        this.tarballNamePrefix = tarballNamePrefix;
    }

    public void setTarballEnabled(Boolean tarballEnabled) {
        this.tarballEnabled = tarballEnabled;
    }

    public void setRequiresAuth(Boolean requiresAuth) {
        this.requiresAuth = requiresAuth;
    }

    public WatchParams getWatchParams() {
        return this.watchParams;
    }

    public FisheyeFileTableData getFisheyeFileTableData() {
        return new FisheyeFileTableData(this.getRepository(), this.getPath());
    }

    private boolean isWatching(Path path, String repName, WaybackSpec wb) {
        try {
            UserLogin user = AppConfig.getsConfig().getUserManager().getCurrentUser(CrucibleFilter.getRequest());
            if (user != null) {
                WatchManager wm = AppConfig.getsConfig().getWatchManager();
                Watch watch = wm.getWatch(user.getUsername(), repName, path, wb);
                return watch != null;
            }
            return false;
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)"Error accessing watch", (Throwable)e2);
            return false;
        }
    }

    public String getRSSFeedUrl() {
        return this.rssFeedUrl;
    }

    public void setRssFeedUrl(String rssFeedUrl) {
        this.rssFeedUrl = rssFeedUrl;
    }

    public String getUrlParamsOrig() {
        UrlHelper helper = new UrlHelper();
        helper.putParams(CrucibleFilter.getRequest().getParameterMap());
        Util.clearQuickSearchStatisticsParams(helper);
        return helper.getParamString();
    }
}

