/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.parameterbeans;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.cache.CvsFileHistory;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.view.FileDiffExplorer;
import com.cenqua.fisheye.diff.view.JSONAnnotation;
import com.cenqua.fisheye.diff.view.JSONDiff;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.vis.Gutter;
import com.cenqua.fisheye.web.FisheyeFileHistoryExplorer;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.UrlHelper;
import com.cenqua.fisheye.web.filehist.FisheyeRevisionTableData;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.cenqua.fisheye.web.parameterbeans.BaseFishEyeServletParams;
import com.cenqua.fisheye.web.parameterbeans.Util;
import com.cenqua.fisheye.web.parameterbeans.WatchParams;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ViewFileActionParams
extends BaseFishEyeServletParams {
    private FileHistory hist;
    private FisheyeFileHistoryExplorer histExplorer;
    private String rev;
    private FileRevision fileRevision;
    private String revname;
    private FileRevision info;
    private boolean isEolTerminated;
    private RegionList regions;
    private String syntaxname;
    private IndexedLineReader lines;
    private String earlierRev;
    private String earlierDiffRev;
    private String laterRev;
    private String laterDiffRev;
    private String r1;
    private FileRevision r1info;
    private String r2;
    private FileRevision r2info;
    private FileDiffExplorer diffs;
    private String histimagemap;
    private String[] keywordOpts;
    private String koptGiven;
    private String kopt;
    private boolean requiresAuth;
    private boolean canAnnotate;
    private boolean canDiff;
    private WatchParams watchParams = new WatchParams();
    private final List<Gutter> gutters = new LinkedList<Gutter>();
    private String originalR1;
    private String originalR2;
    private FisheyeRevisionTableData revisionTableData;
    private boolean viewDiff;
    private boolean viewAnnotation;
    private String rssFeedUrl;
    private DiffOpts diffOpts;
    private UrlHelper urlToDiff;
    private UrlHelper urlToFile;
    private String contextLines;
    private JSONDiff jsonDiff;
    private JSONAnnotation jsonAnnotation;
    private Integer fromBlock;
    private Integer toBlock;
    private Integer annotationBlock;
    private Integer linesPerPage;
    private String errorMessage;

    public ViewFileActionParams(BaseActionParams params, FisheyeRepositoryExplorer repository) {
        super(params);
        this.setRepositoryExplorer(repository);
        this.canDiff = true;
    }

    public void setFileRevision(FileRevision rev) {
        this.fileRevision = rev;
    }

    public FileRevision getFileRevision() {
        return this.fileRevision;
    }

    public FileHistory getHist() {
        return this.hist;
    }

    public FisheyeFileHistoryExplorer getHistExplorer() {
        return this.histExplorer;
    }

    public String getRev() {
        return this.rev;
    }

    public String getRevname() {
        return this.revname;
    }

    public FileRevision getInfo() {
        return this.info;
    }

    public boolean getEolTerminated() {
        return this.isEolTerminated;
    }

    public RegionList getRegions() {
        return this.regions;
    }

    public String getSyntaxname() {
        return this.syntaxname;
    }

    public IndexedLineReader getLines() {
        return this.lines;
    }

    public String getEarlierRev() {
        return this.earlierRev;
    }

    public String getLaterRev() {
        return this.laterRev;
    }

    public String getR1() {
        return this.r1;
    }

    public FileRevision getR1info() {
        return this.r1info;
    }

    public String getR2() {
        return this.r2;
    }

    public FileRevision getR2info() {
        return this.r2info;
    }

    public FileDiffExplorer getDiffs() {
        return this.diffs;
    }

    public JSONDiff getSideBySideDiff() throws IOException {
        if (this.jsonDiff == null) {
            if (this.fromBlock == null) {
                this.fromBlock = -1;
            }
            if (this.toBlock == null) {
                this.toBlock = -1;
            }
            this.jsonDiff = new JSONDiff(this.diffs, this.fromBlock, this.toBlock, this.linesPerPage);
        }
        return this.jsonDiff;
    }

    public JSONAnnotation getJsonAnnotation() throws IOException {
        if (this.jsonAnnotation == null) {
            if (this.annotationBlock == null) {
                this.annotationBlock = 0;
            }
            this.jsonAnnotation = new JSONAnnotation(this.getLines(), this.getRegions(), this.getRepository().getRepName(), this.annotationBlock, this.linesPerPage, this.getGutters());
        }
        return this.jsonAnnotation;
    }

    public void setLinesPerPage(String linesPerPage) {
        try {
            this.linesPerPage = Integer.valueOf(linesPerPage);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setFromBlock(String fromBlock) {
        this.fromBlock = fromBlock == null ? null : this.parseInteger(fromBlock);
    }

    public void setToBlock(String toBlock) {
        this.toBlock = toBlock == null ? null : this.parseInteger(toBlock);
    }

    public void setAnnotationBlock(String annotationBlock) {
        this.annotationBlock = annotationBlock == null ? null : this.parseInteger(annotationBlock);
    }

    private Integer parseInteger(String s2) {
        try {
            return Integer.valueOf(s2);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public String getHistimagemap() {
        return this.histimagemap;
    }

    public String[] getKeywordOpts() {
        return this.keywordOpts;
    }

    public String getKoptGiven() {
        return this.koptGiven;
    }

    public String getKopt() {
        return this.kopt;
    }

    public boolean getRequiresAuth() {
        return this.requiresAuth;
    }

    public KeywordExpansion getHistexpand() {
        if (this.hist instanceof CvsFileHistory) {
            return ((CvsFileHistory)this.hist).getExpand();
        }
        return null;
    }

    public void setHist(FileHistory hist) {
        this.hist = hist;
    }

    public void setHistExplorer(FisheyeFileHistoryExplorer histExplorer) {
        this.histExplorer = histExplorer;
    }

    public void setRev(String rev) {
        this.rev = rev;
    }

    public void setRevname(String revname) {
        this.revname = revname;
    }

    public void setInfo(FileRevision info) {
        this.info = info;
    }

    public void setEolTerminated(boolean eolTerminated) {
        this.isEolTerminated = eolTerminated;
    }

    public void setRegions(RegionList regions) {
        this.regions = regions;
    }

    public void setSyntaxname(String syntaxname) {
        this.syntaxname = syntaxname;
    }

    public void setLines(IndexedLineReader lines) {
        this.lines = lines;
    }

    public void setEarlierRev(String earlierRev) {
        this.earlierRev = earlierRev;
    }

    public void setLaterRev(String laterRev) {
        this.laterRev = laterRev;
    }

    public void setR1(String r1) {
        this.r1 = r1;
    }

    public void setR1info(FileRevision r1info) {
        this.r1info = r1info;
    }

    public void setR2(String r2) {
        this.r2 = r2;
    }

    public void setR2info(FileRevision r2info) {
        this.r2info = r2info;
    }

    public void setDiffs(FileDiffExplorer diffs) {
        this.diffs = diffs;
    }

    public void setHistimagemap(String histimagemap) {
        this.histimagemap = histimagemap;
    }

    public void setKeywordOpts(String[] keywordOpts) {
        this.keywordOpts = keywordOpts;
    }

    public void setKoptGiven(String koptGiven) {
        this.koptGiven = koptGiven;
    }

    public void setKopt(String kopt) {
        this.kopt = kopt;
    }

    public void setRequiresAuth(boolean requiresAuth) {
        this.requiresAuth = requiresAuth;
    }

    public WatchParams getWatchParams() {
        return this.watchParams;
    }

    public void setWatchParams(WatchParams watchParams) {
        this.watchParams = watchParams;
    }

    public List<Gutter> getGutters() {
        return this.gutters;
    }

    public void addGutter(Gutter gutter) {
        this.gutters.add(gutter);
    }

    public int getExtraGutters() {
        return this.gutters.size();
    }

    public void setOriginalR1(String originalR1) {
        this.originalR1 = originalR1;
    }

    public void setOriginalR2(String originalR2) {
        this.originalR2 = originalR2;
    }

    public String getOriginalR1() {
        return this.originalR1;
    }

    public String getOriginalR2() {
        return this.originalR2;
    }

    public Source getSource() {
        return CrucibleFilter.getSource(this.getRepository().getRepName());
    }

    public FisheyeRevisionTableData getMinimalRevisionTableData(Set<Integer> revisionIds) {
        if (this.revisionTableData == null) {
            this.revisionTableData = new FisheyeRevisionTableData(this, this.repositoryExplorer, revisionIds);
        }
        return this.revisionTableData;
    }

    public FisheyeRevisionTableData getRevisionTableData() {
        if (this.revisionTableData == null) {
            this.revisionTableData = new FisheyeRevisionTableData(this, this.repositoryExplorer);
        }
        return this.revisionTableData;
    }

    public void setViewDiff(boolean viewDiff) {
        this.viewDiff = viewDiff;
    }

    public boolean isViewDiff() {
        return this.viewDiff;
    }

    public void setViewAnnotation(boolean viewAnnotation) {
        this.viewAnnotation = viewAnnotation;
    }

    public boolean isViewAnnotation() {
        return this.viewAnnotation;
    }

    public String getEarlierDiffRev() {
        return this.earlierDiffRev;
    }

    public void setEarlierDiffRev(String earlierDiffRev) {
        this.earlierDiffRev = earlierDiffRev;
    }

    public String getLaterDiffRev() {
        return this.laterDiffRev;
    }

    public void setLaterDiffRev(String laterDiffRev) {
        this.laterDiffRev = laterDiffRev;
    }

    public boolean getCanAnnotate() {
        return this.canAnnotate;
    }

    public void setCanAnnotate(boolean canAnnotate) {
        this.canAnnotate = canAnnotate;
    }

    public boolean getCanDiff() {
        return this.canDiff;
    }

    public void setCanDiff(boolean canDiff) {
        this.canDiff = canDiff;
    }

    public void setRSSFeedUrl(String RSSFeedUrl) {
        this.rssFeedUrl = RSSFeedUrl;
    }

    public String getRSSFeedUrl() {
        return this.rssFeedUrl;
    }

    public void setDiffOpts(DiffOpts diffOpts) {
        this.diffOpts = diffOpts;
    }

    public DiffOpts getDiffOpts() {
        return this.diffOpts;
    }

    public void setContextLines(String s2) {
        this.contextLines = s2;
    }

    public String getContextLines() {
        return this.contextLines;
    }

    public UrlHelper getUrlToDiff() {
        if (this.urlToDiff == null) {
            this.urlToDiff = this.getUrlParams();
            this.urlToDiff.putParam("r1", this.r1);
            this.urlToDiff.putParam("r2", this.r2);
        }
        return this.urlToDiff;
    }

    public UrlHelper getUrlToFile() {
        if (this.urlToFile == null) {
            this.urlToFile = this.getUrlParams();
            this.urlToFile.putParam("r", this.rev);
        }
        return this.urlToFile;
    }

    public UrlHelper getUrlParams() {
        UrlHelper urlHelper = new UrlHelper();
        if (this.diffOpts != null) {
            urlHelper.putParam("ignore", this.diffOpts.getOptions());
        }
        if (this.diffs != null) {
            urlHelper.putParam("u", this.diffs.getContextLines());
        } else {
            urlHelper.putParam("u", this.getContextLines());
        }
        return urlHelper;
    }

    public String getUrlParamsOrig() {
        UrlHelper helper = new UrlHelper();
        helper.putParams(CrucibleFilter.getRequest().getParameterMap());
        helper.clearParam("hb");
        Util.clearQuickSearchStatisticsParams(helper);
        return helper.getParamString();
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

