/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.parameterbeans;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.vis.ChartDimension;
import com.cenqua.fisheye.vis.ChartLocation;
import com.cenqua.fisheye.web.ChartOption;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.WaybackSpecChart;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.cenqua.fisheye.web.parameterbeans.BaseFishEyeServletParams;
import com.cenqua.fisheye.web.parameterbeans.DirTreeViewParams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChartPageActionParams
extends BaseFishEyeServletParams {
    private WaybackSpecChart wbSpec;
    private Boolean showAuthorLinecount;
    private String title;
    private List<ChartOption> chartTypeOptions;
    private List<ChartOption> stackTypeOptions;
    private List<ChartOption> authorOptions;
    private List<ChartOption> extnOptions;
    private List<ChartOption> yAxisOptions;
    private ChartDimension chartSize = ChartLocation.MAIN.getParams().getSize();
    private FishEyePathInfo pathInfo;
    private DirTreeViewParams dirTreeViewParams = null;
    private CommitterUserMappingManager committerUserMappingManager;

    public ChartPageActionParams(BaseActionParams params) {
        super(params);
    }

    public Boolean getShowAuthorLinecount() {
        return this.showAuthorLinecount;
    }

    public String getTitle() {
        return this.title;
    }

    public List<ChartOption> getChartTypeOptions() {
        return this.chartTypeOptions;
    }

    public List<ChartOption> getStackTypeOptions() {
        return this.stackTypeOptions;
    }

    public List<ChartOption> getAuthorOptions() {
        return this.authorOptions;
    }

    public List<ChartOption> getExtnOptions() {
        return this.extnOptions;
    }

    public List<ChartOption> getYAxisOptions() {
        return this.yAxisOptions;
    }

    protected CommitterUserMappingManager getCommitterUserMappingManager() {
        if (this.committerUserMappingManager == null) {
            this.committerUserMappingManager = (CommitterUserMappingManager)SpringContext.getComponent("committerUserMappingManager");
        }
        return this.committerUserMappingManager;
    }

    public void setupChartDropdowns(Path path, RepositoryEngine engine) throws DbException {
        this.showAuthorLinecount = engine.getRevisionCache().isAuthorLocEnabled();
        this.chartTypeOptions = this.setupChartTypesDropdown();
        this.stackTypeOptions = this.setupStackTypesDropdown();
        this.yAxisOptions = this.setupYAxisOptions();
        List<String> authors = engine.getRevisionCache().findAuthors(path);
        authors.remove("");
        HashMap<String, String> committerMap = new HashMap<String, String>(authors.size());
        for (String author : authors) {
            FecruUser user = this.getCommitterUserMappingManager().getUserForCommitter(engine.getName(), author);
            if (user == null) {
                committerMap.put(author, author);
                continue;
            }
            committerMap.put(author, user.getDisplayName() + " (" + author + ")");
        }
        this.authorOptions = ChartPageActionParams.setupDropdown(committerMap, this.getWbAuthors());
        Collections.sort(this.authorOptions, new Comparator<ChartOption>(){

            @Override
            public int compare(ChartOption o1, ChartOption o2) {
                return o1.getText().compareToIgnoreCase(o2.getText());
            }
        });
        this.extnOptions = ChartPageActionParams.setupDropdown(engine.getBucketGraph().getAvailableExtensions(path), this.getWbExtns());
        this.extnOptions.add(0, new ChartOption("None", this.getWbExtns().contains("__NO_EXTENSION__"), false, "__NO_EXTENSION__"));
    }

    private static List<ChartOption> setupDropdown(Map<String, String> valueMap, List<String> selectedKeys) {
        ArrayList<ChartOption> types = new ArrayList<ChartOption>();
        for (Map.Entry<String, String> entry : valueMap.entrySet()) {
            boolean selected = selectedKeys != null && selectedKeys.contains(entry.getKey());
            types.add(new ChartOption(entry.getValue(), selected, false, entry.getKey()));
        }
        if (selectedKeys != null) {
            for (String key : selectedKeys) {
                if (valueMap.containsKey(key)) continue;
                types.add(0, new ChartOption(key, true, false));
            }
        }
        return types;
    }

    private static List<ChartOption> setupDropdown(List<String> strings, List<String> selected) {
        ArrayList<ChartOption> types = new ArrayList<ChartOption>();
        for (String s2 : strings) {
            types.add(new ChartOption(s2, false, false));
        }
        if (selected != null) {
            for (String s2 : selected) {
                int index = strings.indexOf(s2);
                if (index < 0) {
                    strings.add(0, s2);
                    types.add(0, new ChartOption(s2, true, false));
                    continue;
                }
                ((ChartOption)types.get(index)).setSelected(true);
            }
        }
        return types;
    }

    List<ChartOption> setupChartTypesDropdown() {
        ArrayList<ChartOption> chartTypes = new ArrayList<ChartOption>();
        ChartOption optionArea = new ChartOption("Area");
        ChartOption optionLine = new ChartOption("Line");
        ChartOption optionPie = new ChartOption("Pie");
        ChartOption optionChangeLine = new ChartOption("Change");
        if (!this.getScmType().isHg()) {
            chartTypes.add(optionArea);
        }
        chartTypes.add(optionLine);
        chartTypes.add(optionPie);
        chartTypes.add(optionChangeLine);
        for (ChartOption option : chartTypes) {
            option.setSelected(option.getText().equalsIgnoreCase(this.getWbChartType()));
        }
        optionPie.setDisabled(this.getWbStackType().equalsIgnoreCase("None"));
        optionChangeLine.setDisabled(this.wbSpec == null || this.wbSpec.getDate1() == null);
        return chartTypes;
    }

    private List<ChartOption> setupStackTypesDropdown() {
        ArrayList<ChartOption> stackTypes = new ArrayList<ChartOption>();
        ChartOption optionNone = new ChartOption("None");
        ChartOption optionSubdir = new ChartOption("Subdirectory");
        ChartOption optionAuthor = new ChartOption("Author");
        ChartOption optionUser = new ChartOption("User");
        ChartOption optionExtn = new ChartOption("Extension");
        stackTypes.add(optionNone);
        stackTypes.add(optionSubdir);
        stackTypes.add(optionAuthor);
        stackTypes.add(optionUser);
        stackTypes.add(optionExtn);
        if (!this.showAuthorLinecount.booleanValue()) {
            optionAuthor.setDisabled(true);
            optionUser.setDisabled(true);
        }
        if (this.getWbChartType().equalsIgnoreCase("Pie")) {
            optionNone.setDisabled(true);
        }
        for (ChartOption option : stackTypes) {
            if (!option.getText().equalsIgnoreCase(this.getWbStackType())) continue;
            option.setSelected(true);
        }
        return stackTypes;
    }

    private List<ChartOption> setupYAxisOptions() {
        ArrayList<ChartOption> yAxisTypes = new ArrayList<ChartOption>();
        ChartOption optionFull = new ChartOption("Full");
        ChartOption optionTight = new ChartOption("Tight");
        yAxisTypes.add(optionFull);
        yAxisTypes.add(optionTight);
        if (this.getWbYAxisType().equalsIgnoreCase("Full")) {
            optionFull.setSelected(true);
        } else {
            optionTight.setSelected(true);
        }
        return yAxisTypes;
    }

    private String getWbYAxisType() {
        if (this.wbSpec != null) {
            return this.wbSpec.getAxisType();
        }
        return "Full";
    }

    private String getWbStackType() {
        if (this.wbSpec != null) {
            return this.wbSpec.getStackType();
        }
        return "None";
    }

    private String getWbChartType() {
        if (this.wbSpec != null) {
            return this.wbSpec.getChartType();
        }
        return "Line";
    }

    private List<String> getWbExtns() {
        List<String> result;
        if (this.wbSpec != null && (result = this.wbSpec.getExtns()) != null) {
            return result;
        }
        return Collections.emptyList();
    }

    private List<String> getWbAuthors() {
        List<String> result;
        if (this.wbSpec != null && (result = this.wbSpec.getAuthors()) != null) {
            return result;
        }
        return Collections.emptyList();
    }

    public boolean isEnableAuthorDropdown() {
        return this.showAuthorLinecount;
    }

    public void setShowAuthorLinecount(Boolean showAuthorLinecount) {
        this.showAuthorLinecount = showAuthorLinecount;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ChartDimension getChartSize() {
        return this.chartSize;
    }

    public FishEyePathInfo getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(FishEyePathInfo pathInfo) {
        this.pathInfo = pathInfo;
    }

    public WaybackSpecChart getWbSpecChart() {
        return this.wbSpec;
    }

    public void setWbSpecChart(WaybackSpecChart wbSpecChart) {
        this.wbSpec = wbSpecChart;
    }
}

