/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.parameterbeans;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.web.CookiePreferences;
import javax.annotation.Nullable;

public class BaseActionParams {
    private RepositoryConfig repositoryConfig;
    private RepositoryEngine repositoryEngine;
    private RepositoryStatus slurpStatus;
    private Boolean isWatchesEnabled;
    private Boolean isPipelined;
    private CookiePreferences prefs;

    public BaseActionParams(RepositoryEngine engine) {
        this.repositoryConfig = null;
        this.repositoryEngine = engine;
        this.slurpStatus = null;
        this.prefs = null;
        this.isWatchesEnabled = null;
        this.isPipelined = null;
    }

    public BaseActionParams(BaseActionParams params) {
        this(params.getRepname(), params.getUserPrefs());
    }

    public BaseActionParams(String repository, CookiePreferences prefs) {
        RepositoryHandle repositoryHandle = AppConfig.getsConfig().getRepositoryManager().getRepository(repository);
        try {
            this.repositoryEngine = repositoryHandle.acquireEngine();
            this.repositoryConfig = repositoryHandle.getCfg();
            this.slurpStatus = repositoryHandle.getStatus();
            this.isWatchesEnabled = this.isMailerConfigured() && this.repositoryEngine.getCfg().isWatchesEnabled();
            this.isPipelined = repositoryHandle.isPipelined();
            this.prefs = prefs;
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.error((Object)("Cannot acquire engine for " + repositoryHandle), (Throwable)((Object)e2));
        }
    }

    public RepositoryConfig getRepositoryConfig() {
        return this.repositoryConfig;
    }

    public RepositoryEngine getRepositoryEngine() {
        return this.repositoryEngine;
    }

    public String getRepname() {
        return this.repositoryEngine.getName();
    }

    public ScmType getScmType() {
        return this.repositoryConfig.getRepositoryType();
    }

    public RepositoryStatus getSlurpStatus() {
        return this.slurpStatus;
    }

    public Boolean getWatchesEnabled() {
        return this.isWatchesEnabled;
    }

    public boolean isPipelined() {
        return this.isPipelined;
    }

    public double getScanningPercentage() {
        return this.slurpStatus.getScanningPercentage();
    }

    public CookiePreferences getUserPrefs() {
        return this.prefs;
    }

    private boolean isMailerConfigured() {
        return SpringContext.getComponentByClass(Mailer.class).isConfigured();
    }

    @Nullable
    public String getDefaultBranch() {
        return this.repositoryEngine.getRevisionCache().getDefaultBranch();
    }
}

