/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.paging;

import com.atlassian.fecru.page.PageRequest;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.paging.PaginationItem;
import com.cenqua.fisheye.web.paging.PagingCalculator;
import com.cenqua.fisheye.web.paging.Separator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class TotalCountAwarePagingCalculator
implements PagingCalculator {
    private final int page;
    private final int numPages;
    private final int numPerPage;
    private final int numItems;

    public static TotalCountAwarePagingCalculator getPagingCalculator(HttpServletRequest request, int numItems, int numPerPage) {
        int fromRequest = 1;
        try {
            String page = request.getParameter("page");
            if (page != null) {
                fromRequest = Integer.parseInt(page);
            }
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.warn((Object)"Incorrect page passed to page calculator from request");
        }
        return TotalCountAwarePagingCalculator.getPagingCalculator(fromRequest, numItems, numPerPage);
    }

    public static TotalCountAwarePagingCalculator getPagingCalculator(HttpServletRequest request, int numItems) {
        return TotalCountAwarePagingCalculator.getPagingCalculator(request, numItems, 30);
    }

    public static TotalCountAwarePagingCalculator getPagingCalculator(int page, int numItems, int numPerPage) {
        return new TotalCountAwarePagingCalculator(page, numItems, numPerPage);
    }

    public static TotalCountAwarePagingCalculator getPagingCalculator(int page, int numItems) {
        return TotalCountAwarePagingCalculator.getPagingCalculator(page, numItems, 30);
    }

    protected TotalCountAwarePagingCalculator(int page, int numItems, int numPerPage) {
        this.numItems = numItems;
        this.numPerPage = numPerPage;
        this.numPages = numItems / numPerPage + (numItems % numPerPage != 0 ? 1 : 0);
        this.page = page > this.numPages ? this.numPages : page;
    }

    @Override
    public int getNumPerPage() {
        return this.numPerPage;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    public int getNumPages() {
        return this.numPages;
    }

    @Override
    public PageRequest createPageRequest() {
        return PageRequest.create((Integer)this.getCurrentPageStart(), (Integer)this.getNumPerPage());
    }

    @Override
    public int getCurrentPageStart() {
        int first = (this.getPage() - 1) * this.numPerPage;
        if (first <= 0 || first > this.numItems) {
            first = 0;
        }
        return first;
    }

    @Override
    public int getCurrentPageEnd() {
        int end = (this.getPage() - 1) * this.numPerPage + this.numPerPage;
        if (end > this.numItems) {
            end = this.numItems;
        }
        return end;
    }

    @Override
    public boolean isLastPage() {
        return this.numPages == 0 || this.getPage() == this.numPages;
    }

    @Override
    public boolean isFirstPage() {
        return this.numPages == 0 || this.getPage() == 1;
    }

    @Override
    public boolean isSinglePage() {
        return this.isFirstPage() && this.isLastPage();
    }

    public int getNumItems() {
        return this.numItems;
    }

    public boolean getNoResults() {
        return this.numItems == 0;
    }

    @Override
    public List<PaginationItem> generatePagination() {
        return this.generatePagination(6, 2, 2, 5, 4);
    }

    private List<PaginationItem> generatePagination(int centerGroupSize, int leftGroupSize, int rightGroupSize, int leftCenterMinGap, int centerRightMinGap) {
        LinkedList<PaginationItem> paginationItems = new LinkedList<PaginationItem>();
        int centerGroupStart = (int)((double)this.page - Math.floor((centerGroupSize - 1) / 2));
        int centerGroupEnd = (int)((double)this.page + Math.ceil(((double)centerGroupSize - 1.0) / 2.0));
        if (centerGroupStart < 1) {
            centerGroupEnd += Math.abs(1 - centerGroupStart);
            centerGroupStart = 1;
        }
        if (centerGroupEnd > this.numPages) {
            if ((centerGroupStart -= centerGroupEnd - this.numPages) < 1) {
                centerGroupStart = 1;
            }
            centerGroupEnd = this.numPages;
        }
        if (Math.abs(centerGroupStart - leftGroupSize) >= leftCenterMinGap) {
            this.populatePagesRange(paginationItems, 1, leftGroupSize);
            this.addSeparator(paginationItems);
        } else {
            this.populatePagesRange(paginationItems, 1, centerGroupStart - 1);
        }
        this.populatePagesRange(paginationItems, centerGroupStart, centerGroupEnd);
        if (Math.abs(this.numPages - centerGroupEnd - rightGroupSize) >= centerRightMinGap) {
            this.addSeparator(paginationItems);
            this.populatePagesRange(paginationItems, this.numPages - rightGroupSize + 1, this.numPages);
        } else if (centerGroupEnd != this.numPages) {
            this.populatePagesRange(paginationItems, centerGroupEnd + 1, this.numPages);
        }
        return paginationItems;
    }

    private void populatePagesRange(List<PaginationItem> paginationItems, int rangeStart, int rangeEnd) {
        for (int i2 = rangeStart; i2 <= rangeEnd; ++i2) {
            paginationItems.add(new PaginationItem(i2, this.page == i2));
        }
    }

    private void addSeparator(List<PaginationItem> paginationItems) {
        paginationItems.add(Separator.instance);
    }
}

