/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.paging;

import com.atlassian.fecru.page.PageRequest;
import com.cenqua.fisheye.web.paging.PaginationItem;
import com.cenqua.fisheye.web.paging.PagingCalculator;
import com.cenqua.fisheye.web.paging.TotalCountAwarePagingCalculator;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class PreviousNextPagingCalculator
implements PagingCalculator {
    private final PagingCalculator delegate;
    private Boolean lastPage;

    public PreviousNextPagingCalculator(HttpServletRequest request) {
        this.delegate = TotalCountAwarePagingCalculator.getPagingCalculator(request, Integer.MAX_VALUE);
        Preconditions.checkArgument((this.getPage() >= 1 ? 1 : 0) != 0);
    }

    @Override
    public boolean isFirstPage() {
        return this.delegate.isFirstPage();
    }

    @Override
    public boolean isLastPage() {
        Preconditions.checkState((this.lastPage != null ? 1 : 0) != 0, (Object)"Last page condition not set");
        return this.lastPage;
    }

    public void setLastPage(Boolean lastPage) {
        this.lastPage = lastPage;
    }

    @Override
    public boolean isSinglePage() {
        return this.isFirstPage() && this.isLastPage();
    }

    @Override
    public List<PaginationItem> generatePagination() {
        return Collections.emptyList();
    }

    @Override
    public int getNumPerPage() {
        return this.delegate.getNumPerPage();
    }

    @Override
    public int getPage() {
        return this.delegate.getPage();
    }

    @Override
    public PageRequest createPageRequest() {
        return this.delegate.createPageRequest();
    }

    @Override
    public int getCurrentPageStart() {
        return this.delegate.getCurrentPageStart();
    }

    @Override
    public int getCurrentPageEnd() {
        return this.delegate.getCurrentPageEnd();
    }
}

