/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.mime;

import com.cenqua.fisheye.logging.Logs;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class HostileExtensionDetector {
    private static final Logger log = Logs.APP_LOG;
    private static final String DELIMITER_REGEX = "\\s+";
    private static final String KEY_EXECUTABLE_CONTENT_TYPES = "executable.mime.types";
    private static final String KEY_EXECUTABLE_FILE_EXTENSIONS = "executable.file.extensions";
    private static final String KEY_TEXT_FILE_EXTENSIONS = "text.file.extensions";
    private static final String KEY_TEXT_FILE_CONTENT_TYPES = "text.file.mime.types";
    private static final String CONFIG_FILE = "hostile-attachments-config.properties";
    private static final Set<String> DEFAULT_EXECUTABLE_FILE_EXTENSIONS = ImmutableSet.of((Object)".txt", (Object)".htm", (Object)".html", (Object)".xhtml", (Object)".xml", (Object)".svg", (Object[])new String[]{".swf", ".cab", ".flv", ".f4v", ".f4p", ".f4a", ".f4b"});
    private static final Set<String> DEFAULT_TEXT_FILE_EXTENSIONS = ImmutableSet.of((Object)".txt", (Object)".htm", (Object)".html", (Object)".xhtml", (Object)".xml");
    private static final Set<String> DEFAULT_TEXT_FILE_CONTENT_TYPES = ImmutableSet.of((Object)"text/plain", (Object)"text/html", (Object)"text/html-sandboxed", (Object)"text/xhtml", (Object)"application/xhtml+xml", (Object)"text/xml", (Object[])new String[]{"application/xml"});
    private static final Set<String> DEFAULT_EXECUTABLE_CONTENT_TYPES = ImmutableSet.of((Object)"text/plain", (Object)"text/html", (Object)"text/html-sandboxed", (Object)"text/xhtml", (Object)"application/xhtml+xml", (Object)"text/xml", (Object[])new String[]{"application/xml", "text/xml-external-parsed-entity", "application/xml-external-parsed-entity", "application/xml-dtd", "application/x-shockwave-flash", "image/svg+xml", "image/svg-xml", "application/futuresplash"});
    private Set<String> executableFileExtensions;
    private Set<String> textfileExtensions;
    private Set<String> textfileContentTypes;
    private Set<String> executableContentTypes;

    public HostileExtensionDetector() {
        this.loadConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration() {
        Properties config = new Properties();
        InputStream in = this.getClass().getResourceAsStream(CONFIG_FILE);
        if (in != null) {
            try {
                config.load(in);
            }
            catch (IOException e2) {
                log.warn((Object)"Unable to load config from 'hostile-attachments-config.properties' falling back to defaults ");
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        } else {
            log.warn((Object)"Unable to load config from 'hostile-attachments-config.properties' falling back to defaults ");
        }
        this.parseConfiguration(config);
    }

    private void parseConfiguration(Properties config) {
        this.executableFileExtensions = this.getProperty(config, KEY_EXECUTABLE_FILE_EXTENSIONS, DEFAULT_EXECUTABLE_FILE_EXTENSIONS);
        this.executableContentTypes = this.getProperty(config, KEY_EXECUTABLE_CONTENT_TYPES, DEFAULT_EXECUTABLE_CONTENT_TYPES);
        this.textfileExtensions = this.getProperty(config, KEY_TEXT_FILE_EXTENSIONS, DEFAULT_TEXT_FILE_EXTENSIONS);
        this.textfileContentTypes = this.getProperty(config, KEY_TEXT_FILE_CONTENT_TYPES, DEFAULT_TEXT_FILE_CONTENT_TYPES);
    }

    private Set<String> getProperty(Properties config, String key, Set<String> defaultValue) {
        String extensions = config.getProperty(key);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configured executable file extensions: '" + extensions + "'"));
        }
        if (!StringUtils.isBlank((String)extensions)) {
            return ImmutableSet.copyOf((Object[])extensions.toLowerCase(Locale.US).trim().split(DELIMITER_REGEX));
        }
        return defaultValue;
    }

    public boolean isExecutableFileExtension(String name) {
        boolean isExecutableFileExtension = false;
        if (!StringUtils.isBlank((String)name)) {
            isExecutableFileExtension = this.executableFileExtensions.contains(this.getFileExtension(name));
        }
        return isExecutableFileExtension;
    }

    private String getFileExtension(String name) {
        return name.contains(".") ? name.substring(name.lastIndexOf("."), name.length()).toLowerCase(Locale.US) : "";
    }

    public boolean isExecutableContentType(String contentType) {
        boolean isExecutableContentType = false;
        if (!StringUtils.isBlank((String)contentType)) {
            isExecutableContentType = this.executableContentTypes.contains(contentType.toLowerCase(Locale.US));
        }
        return isExecutableContentType;
    }

    public boolean isTextExtension(String fileName) {
        boolean isTextFileExtension = false;
        if (!StringUtils.isBlank((String)fileName)) {
            isTextFileExtension = this.textfileExtensions.contains(this.getFileExtension(fileName));
        }
        return isTextFileExtension;
    }

    public boolean isTextContentType(String contentType) {
        boolean isTextContentType = false;
        if (!StringUtils.isBlank((String)contentType)) {
            isTextContentType = this.textfileContentTypes.contains(contentType.toLowerCase(Locale.US));
        }
        return isTextContentType;
    }
}

