/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.mime;

import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RawPolicyType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.mime.DownloadPolicy;
import com.cenqua.fisheye.web.mime.DownloadPolicyProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FisheyeDownloadPolicyProvider
implements DownloadPolicyProvider {
    private final RootConfig rootConfig;

    @Autowired
    public FisheyeDownloadPolicyProvider(RootConfig rootConfig) {
        this.rootConfig = rootConfig;
    }

    @Override
    public DownloadPolicy getPolicy() {
        return this.getPolicyImpl(DownloadPolicy.Smart);
    }

    private DownloadPolicy getPolicyImpl(DownloadPolicy defaultPolicy) {
        RawPolicyType rawPolicy;
        SecurityType security;
        ConfigDocument.Config config = this.rootConfig.getConfig();
        DownloadPolicy policy = defaultPolicy;
        if (config.isSetSecurity() && (security = config.getSecurity()).isSetRawPolicy() && (rawPolicy = security.getRawPolicy()).isSetPolicy()) {
            try {
                policy = DownloadPolicy.valueOf(rawPolicy.getPolicy().toString());
            }
            catch (IllegalArgumentException e2) {
                Logs.APP_LOG.warn((Object)("Found invalid file download policy type in config.xml : " + rawPolicy.getPolicy().toString()));
                policy = defaultPolicy;
            }
        }
        return policy;
    }
}

