/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.mime;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.mime.BrowserUtils;
import com.cenqua.fisheye.web.mime.DownloadPolicy;
import com.cenqua.fisheye.web.mime.DownloadPolicyProvider;
import com.cenqua.fisheye.web.mime.HostileExtensionDetector;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentDispositionHeaderGuesser {
    private static final Logger log = Logs.APP_LOG;
    private static final String CONTENT_DISPOSITION_ATTACHMENT = "attachment";
    private static final String CONTENT_DISPOSITION_INLINE = "inline";
    private final DownloadPolicyProvider downloadPolicyProvider;
    private final HostileExtensionDetector hostileExtensionDetector;

    @Autowired
    public ContentDispositionHeaderGuesser(DownloadPolicyProvider downloadPolicyProvider, HostileExtensionDetector hostileExtensionDetector) {
        this.downloadPolicyProvider = downloadPolicyProvider;
        this.hostileExtensionDetector = hostileExtensionDetector;
    }

    public String guessContentDispositionHeader(String fileName, String mimeContentType, String userAgent) {
        DownloadPolicy downloadPolicy = this.downloadPolicyProvider.getPolicy();
        boolean forceDownload = false;
        if (downloadPolicy != DownloadPolicy.Insecure && this.isExecutableContent(fileName, mimeContentType)) {
            forceDownload = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("\"" + fileName + "\" (" + mimeContentType + ")" + " presents as executable content, forcing download."));
            }
        } else if (downloadPolicy == DownloadPolicy.Secure) {
            forceDownload = true;
        }
        if (forceDownload && this.isAllowInlineOverride(fileName, mimeContentType, userAgent, downloadPolicy)) {
            forceDownload = false;
        }
        return forceDownload ? CONTENT_DISPOSITION_ATTACHMENT : CONTENT_DISPOSITION_INLINE;
    }

    public String guessMIME(String filename, String mimeContentType, String userAgent) {
        if (CONTENT_DISPOSITION_INLINE.equals(this.guessContentDispositionHeader(filename, mimeContentType, userAgent)) && this.isAllowInlineOverride(filename, mimeContentType, userAgent, this.downloadPolicyProvider.getPolicy())) {
            return "text/plain";
        }
        return mimeContentType;
    }

    private boolean isAllowInlineOverride(String fileName, String mimeContentType, String userAgent, DownloadPolicy downloadPolicy) {
        return downloadPolicy == DownloadPolicy.Smart && !BrowserUtils.isIE(userAgent) && this.isTextContent(fileName, mimeContentType);
    }

    private boolean isTextContent(String fileName, String mimeContentType) {
        return this.hostileExtensionDetector.isTextExtension(fileName) && this.hostileExtensionDetector.isTextContentType(mimeContentType);
    }

    private boolean isExecutableContent(String name, String mimeContentType) {
        return this.hostileExtensionDetector.isExecutableFileExtension(name) || this.hostileExtensionDetector.isExecutableContentType(mimeContentType);
    }
}

