/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.login;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.managers.InviteManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.user.UserUtils;
import com.cenqua.fisheye.web.admin.util.PasswordActionUtils;
import com.cenqua.fisheye.web.login.BaseLoginAction;
import com.cenqua.fisheye.web.security.CaptchaManager;
import com.google.common.base.Strings;
import com.octo.captcha.service.CaptchaServiceException;
import java.util.List;
import javax.annotation.Resource;

public class SignupAction
extends BaseLoginAction {
    @Resource
    protected RootConfig rootConfig;
    private String username;
    private String password1;
    private String password2;
    private boolean crucibleEnabled;
    private String captchaid;
    private String captchaResponse;
    private boolean invited;
    private String email;
    private String displayName;
    private static final String FIELD_USERNAME = "username";
    private static final String FIELD_DISPLAYNAME = "displayName";
    private static final String FIELD_USEREMAIL = "email";
    private static final String FIELD_PASSWORD1 = "password1";
    private static final String FIELD_PASSWORD2 = "password2";
    private static final String FIELD_CHAPTCHA = "captchaResponse";

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isInvited() {
        return this.invited;
    }

    public void setInvited(boolean invited) {
        this.invited = invited;
    }

    public String getCaptchaid() {
        return this.captchaid;
    }

    public void setCaptchaid(String captchaid) {
        this.captchaid = captchaid;
    }

    public void setCaptchaResponse(String captchaResponse) {
        this.captchaResponse = captchaResponse;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword1() {
        return this.password1;
    }

    public void setPassword1(String password1) {
        this.password1 = password1;
    }

    public String getPassword2() {
        return this.password2;
    }

    public void setPassword2(String password2) {
        this.password2 = password2;
    }

    public void validate() {
        boolean signupEnabled = AppConfig.getsConfig().getConfig().getSecurity().getBuiltIn().getSignup().getEnabled();
        if (!signupEnabled) {
            this.addActionError("Signup disabled.");
            return;
        }
        if (this.hasErrors()) {
            return;
        }
        UserManager um = this.getUserManager();
        this.username = UserUtils.sanitize(this.username);
        try {
            String existingUser;
            if (um.getUser(this.username) != null) {
                this.addFieldError(FIELD_USERNAME, "An user with that name already exists");
            }
            if (!Strings.isNullOrEmpty((String)this.email) && (existingUser = um.getUsernameByEmail(this.email)) != null) {
                this.addFieldError(FIELD_USEREMAIL, "The user's email address must be unique, but it is currently used by " + existingUser);
            }
            if (!um.isUserNameValid(this.username)) {
                this.addFieldError(FIELD_USERNAME, "Username can only contain alphanumeric, underscore, at ('@'), dot, dash or backslash");
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"problem adding user", (Throwable)e2);
            this.addActionError("The user could not be created because of an internal error (please check the logs for more information).");
        }
        PasswordActionUtils.checkPassword(this, this.password1, this.password2);
        if (this.hasErrors()) {
            return;
        }
        if (!this.isCaptchaEnabled()) {
            return;
        }
        if (Strings.isNullOrEmpty((String)this.captchaid)) {
            this.addActionError("Internal problem with CAPTCHA.");
            return;
        }
        if (Strings.isNullOrEmpty((String)this.captchaResponse)) {
            this.addFieldError(FIELD_CHAPTCHA, "Please enter the word in the image.");
            return;
        }
        Boolean valid = null;
        try {
            valid = CaptchaManager.getInstance().validateResponseForID(this.captchaid, this.captchaResponse);
        }
        catch (CaptchaServiceException e3) {
            Logs.APP_LOG.info((Object)"problem validating captcha", (Throwable)e3);
            this.addActionError("Internal problem with CAPTCHA.");
        }
        if (valid == null || !valid.booleanValue()) {
            this.addFieldError(FIELD_CHAPTCHA, "Incorrect, try again.");
        }
    }

    public boolean isCrucibleEnabled() {
        return this.crucibleEnabled;
    }

    public void setCrucibleEnabled(boolean crucibleEnabled) {
        this.crucibleEnabled = crucibleEnabled;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        this.captchaid = CaptchaManager.getInstance().makeCaptchaId();
        return super.doDefault();
    }

    private String doUserAdd() {
        try {
            UserManager um = this.getUserManager();
            FecruUser fecruUser = um.addUser(this.username, this.displayName, this.email, this.password1, true);
            InviteManager.deleteCrucibleInviteUser(this.email, fecruUser);
            return "success";
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"problem adding user", (Throwable)e2);
            this.addActionError("The user could not be created because of an internal error (please check the logs for more information).");
            return "input";
        }
        catch (LicensePolicyException e3) {
            Logs.APP_LOG.warn((Object)"problem adding user", (Throwable)e3);
            this.addActionError("The user could not be created: " + e3.getMessage());
            return "input";
        }
    }

    public String execute() {
        String response = this.doUserAdd();
        if (this.invited && "success".equals(response)) {
            return "success.cru";
        }
        return response;
    }

    public boolean isCaptchaEnabled() {
        return AppConfig.getsConfig().getConfig().getSecurity().getBuiltIn().getUseCaptcha();
    }

    public List getUserNameFieldErrors() {
        return this.getFieldErrors(FIELD_USERNAME);
    }

    public List getDisplayNameFieldErrors() {
        return this.getFieldErrors(FIELD_DISPLAYNAME);
    }

    public List getUserEmailFieldErrors() {
        return this.getFieldErrors(FIELD_USEREMAIL);
    }

    public List getPassword1FieldErrors() {
        return this.getFieldErrors(FIELD_PASSWORD1);
    }

    public List getPassword2FieldErrors() {
        return this.getFieldErrors(FIELD_PASSWORD2);
    }

    public List getCaptchaFieldErrors() {
        return this.getFieldErrors(FIELD_CHAPTCHA);
    }

    public SignupAction getAction() {
        return this;
    }
}

