/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.login;

import com.atlassian.fecru.template.TemplateManager;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fisheye.spi.data.MailMessageData;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.util.FreemarkerUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.login.BaseLoginAction;
import com.cenqua.fisheye.web.security.CaptchaManager;
import com.google.common.base.Strings;
import com.octo.captcha.service.CaptchaServiceException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public class RequestPasswordResetAction
extends BaseLoginAction {
    private static final String VERIFY_TEMPLATE = "verify-password-reset.ftl";
    protected String usernameOrEmail;
    protected String captchaId;
    protected String captchaResponse;
    @Resource
    private TemplateManager templateManager;
    @Resource
    private UserProfileManager userProfileManager;
    @Resource
    private Mailer mailer;
    private static final String FIELD_CAPTCHA_RESPONSE = "captchaResponse";

    public String getUsernameOrEmail() {
        return this.usernameOrEmail;
    }

    public void setUsernameOrEmail(String usernameOrEmail) {
        this.usernameOrEmail = usernameOrEmail;
    }

    public String getCaptchaId() {
        return this.captchaId;
    }

    public void setCaptchaId(String captchaId) {
        this.captchaId = captchaId;
    }

    public String getCaptchaResponse() {
        return this.captchaResponse;
    }

    public void setCaptchaResponse(String captchaResponse) {
        this.captchaResponse = captchaResponse;
    }

    public boolean isCaptchaEnabled() {
        return AppConfig.getsConfig().getConfig().getSecurity().getBuiltIn().getUseCaptcha();
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        this.assignCaptchaId();
        return super.doDefault();
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        FecruUser user = this.validateUser();
        if (user != null) {
            String secRnd = this.generateSecureRnd();
            if (!this.sendVerificationEmail(user, secRnd)) {
                this.addActionError("Failed to send verification email");
                return "input";
            }
            this.getUserManager().requestPasswordReset(user.getUsername(), secRnd);
        }
        return super.execute();
    }

    public void validate() {
        this.validateCaptcha();
        if (this.hasErrors()) {
            return;
        }
        if (!this.isMailServerConfigured()) {
            this.addActionError("No SMTP server configured");
            return;
        }
        this.validateUser();
    }

    protected FecruUser validateUser() {
        UserManager userManager;
        FecruUser user;
        if (Strings.isNullOrEmpty((String)this.usernameOrEmail)) {
            this.addActionError("You must specify a username or email");
            return null;
        }
        try {
            user = this.getUserFromUsername(this.usernameOrEmail);
            if (user == null) {
                String username = this.getUsernameFromEmail(this.usernameOrEmail);
                if (username != null) {
                    user = this.getUserFromUsername(username);
                }
                if (user == null) {
                    return null;
                }
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"error getting user", (Throwable)e2);
            this.addActionError("Internal DB problem (see logs)");
            return null;
        }
        if (!(this.hasErrors() || !(userManager = this.getUserManager()).isPasswordlessAuthenticationEnabled() && userManager.canUpdateUser(user.getUsername()))) {
            this.addActionError("Cannot update password for specified user");
            return null;
        }
        return user;
    }

    protected FecruUser getUserFromUsername(String username) throws DbException {
        return this.getUserManager().getLicensedUser(username);
    }

    protected String getUsernameFromEmail(String email) throws DbException {
        return this.getUserManager().getUsernameByEmail(email);
    }

    public List<String> getCaptchaErrors() {
        return this.getFieldErrors(FIELD_CAPTCHA_RESPONSE);
    }

    protected void validateCaptcha() {
        if (!this.isCaptchaEnabled()) {
            return;
        }
        if (Strings.isNullOrEmpty((String)this.captchaId)) {
            Logs.APP_LOG.error((Object)"captchaId was null or zero-length");
            this.addActionError("Internal problem with CAPTCHA, please try again.");
            return;
        }
        if (Strings.isNullOrEmpty((String)this.captchaResponse)) {
            this.addFieldError(FIELD_CAPTCHA_RESPONSE, "Please enter the word in the image.");
            return;
        }
        try {
            if (!this.validateCaptchaResponse().booleanValue()) {
                this.addFieldError(FIELD_CAPTCHA_RESPONSE, "Incorrect, try again.");
            }
        }
        catch (CaptchaServiceException e2) {
            Logs.APP_LOG.error((Object)"problem validating captcha", (Throwable)e2);
            this.addActionError("Internal problem with CAPTCHA, please try again.");
        }
    }

    protected boolean sendEmail(FecruUser user, Map<String, Object> fMParams, String templateName, String subject) throws IOException, TemplateException, DbException {
        String contentType = this.resolvePreferredMailFormat(user);
        boolean isHtml = contentType.equals("text/html; charset=UTF-8");
        Template csTmpl = this.templateManager.getFishEyeTemplate(templateName, isHtml);
        fMParams.put("siteurl", AppConfig.getsConfig().getSiteURL());
        fMParams.put("appnametag", AppConfig.getProductName());
        fMParams.put("displayName", user.getDisplayName());
        fMParams.put("username", user.getUsername());
        fMParams.put("email", user.getEmail());
        StringWriter msg = new StringWriter();
        csTmpl.process(fMParams, (Writer)msg);
        msg.flush();
        MailMessageData mailMessage = new MailMessageData();
        mailMessage.addRecipient(user.getEmail());
        mailMessage.setSubject(subject);
        mailMessage.setBodyText(contentType, msg.toString());
        return this.mailer.sendMessage(mailMessage);
    }

    protected boolean sendVerificationEmail(FecruUser user, String code) throws IOException, TemplateException, DbException {
        Map<String, Object> fMParams = FreemarkerUtil.init();
        fMParams.put("code", code);
        return this.sendEmail(user, fMParams, VERIFY_TEMPLATE, AppConfig.getProductName() + " Password Reset");
    }

    protected String resolvePreferredMailFormat(FecruUser user) throws DbException {
        UserProfile profile = this.userProfileManager.getProfile(user.getUsername());
        if (profile.getEmailFormat() == 1) {
            return "text/html; charset=UTF-8";
        }
        return "text/plain; charset=UTF-8";
    }

    protected boolean isMailServerConfigured() {
        return this.mailer.isConfigured();
    }

    protected void assignCaptchaId() {
        this.captchaId = CaptchaManager.getInstance().makeCaptchaId();
    }

    protected Boolean validateCaptchaResponse() {
        return CaptchaManager.getInstance().validateResponseForID(this.captchaId, this.captchaResponse);
    }

    protected String generateSecureRnd() {
        return this.getUserManager().makeSecureRnd();
    }

    @Autowired
    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    @Autowired
    public void setMailer(Mailer mailer) {
        this.mailer = mailer;
    }
}

