/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.login;

import com.atlassian.fecru.properties.UserRepositoryPropertyManager;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.util.FreemarkerUtil;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.web.login.RequestPasswordResetAction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Resource;

public class PasswordResetAction
extends RequestPasswordResetAction {
    @Resource
    private UserRepositoryPropertyManager userRepositoryPropertyManager;
    private static final String TEMPLATE = "password-reset.ftl";
    private static final long CODE_EXPIRY_MS = 86400000L;
    private static final int NEW_PASSWORD_LENGTH = 8;
    private String code;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String doDefault() throws Exception {
        return "input";
    }

    @Override
    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        String newPassword = this.generateNewPassword();
        FecruUser user = this.validateUser();
        if (!this.sendPasswordEmail(user, newPassword)) {
            this.addActionError("Failed to send password email");
            return "input";
        }
        this.userManager.resetPassword(user.getUsername(), newPassword);
        return "success";
    }

    @Override
    public void validate() {
        if (!this.isMailServerConfigured()) {
            this.addActionError("No SMTP server configured");
            return;
        }
        FecruUser user = this.validateUser();
        if (user == null) {
            this.addActionError("User has not requested password reset or bad verification code was provided");
            return;
        }
        if (this.hasErrors()) {
            return;
        }
        String passwordResetSRnd = user.getPasswordResetSRnd();
        Long passwordResetTimeStamp = user.getPasswordResetTimeStamp();
        if (Strings.isNullOrEmpty((String)passwordResetSRnd) || Strings.isNullOrEmpty((String)this.code) || !this.code.equals(passwordResetSRnd)) {
            this.addActionError("User has not requested password reset or bad verification code was provided");
        } else if (System.currentTimeMillis() - passwordResetTimeStamp - 86400000L > 0L) {
            this.addActionError("Verification code expired");
        }
    }

    protected boolean sendPasswordEmail(FecruUser user, String newPassword) throws IOException, TemplateException, DbException {
        Map<String, Object> fMParams = FreemarkerUtil.init();
        fMParams.put("password", newPassword);
        return this.sendEmail(user, fMParams, TEMPLATE, "New FishEye Password");
    }

    protected String generateNewPassword() {
        return this.userManager.makeSecureRnd(8);
    }

    @VisibleForTesting
    protected void setUserRepositoryPropertyManager(UserRepositoryPropertyManager userRepositoryPropertyManager) {
        this.userRepositoryPropertyManager = userRepositoryPropertyManager;
    }
}

