/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.login;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.managers.InviteManager;
import com.cenqua.fisheye.web.LoginServlet;

public class AcceptInviteAction
extends BaseAction {
    private boolean invited;
    private String address;
    private int reviewCount = 0;

    public int getReviewCount() {
        if (this.reviewCount == 0) {
            this.reviewCount = InviteManager.getReviewsByInvitee(this.address).size();
        }
        return this.reviewCount;
    }

    public boolean isInvited() {
        return this.invited;
    }

    public void setInvited(boolean invited) {
        this.invited = invited;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        if (this.address == null) {
            this.addActionError("user not found (" + this.address + ").");
            return "login";
        }
        return "success";
    }

    public String acceptFromExistingUser() throws Exception {
        if (LoginServlet.login(this.getRequest(), this.getResponse())) {
            return this.acceptFromCurrentUser();
        }
        this.getRequest().setAttribute("fisheye.forward.request_uri", (Object)(this.getRequest().getContextPath() + "/login/acceptInvite-current.do"));
        return "login";
    }

    @RequireSecurityToken(value=false)
    public String acceptFromCurrentUser() throws Exception {
        if (this.effectiveUserProvider.getEffectiveUser() == null) {
            return "login";
        }
        InviteManager.deleteCrucibleInviteUser(this.address, this.effectiveUserProvider.getEffectiveUser());
        return "success";
    }
}

