/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.jetty;

import com.cenqua.fisheye.logging.Logs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.eclipse.jetty.util.resource.Resource;

public class MultiPathResource
extends Resource {
    private final Resource primary;
    private final List<Resource> others;

    public MultiPathResource(Resource primary) {
        this.primary = primary;
        this.others = new ArrayList<Resource>();
        this.others.add(primary);
    }

    private MultiPathResource(Resource primary, List others) {
        this.primary = primary;
        this.others = others;
    }

    public void addOther(Resource other) {
        this.others.add(0, other);
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        Resource best = null;
        Resource last = null;
        for (int i2 = 0; i2 < this.others.size(); ++i2) {
            Resource r2;
            Resource other = this.others.get(i2);
            last = r2 = other.addPath(path);
            if (r2 == null || !r2.exists()) continue;
            best = r2;
            break;
        }
        Resource result = best != null ? best : last;
        return result == null ? null : new MultiPathResource(result, this.others);
    }

    public String encode(String uri) {
        return this.primary.encode(uri);
    }

    public URL getAlias() {
        return this.primary.getAlias();
    }

    public boolean isContainedIn(Resource r2) throws MalformedURLException {
        Logs.APP_LOG.error((Object)"MultiPathResource.isContainedIn() called, not implemented currently", (Throwable)new NotImplementedException());
        return false;
    }

    public void release() {
        this.primary.release();
    }

    public boolean exists() {
        return this.primary.exists();
    }

    public boolean isDirectory() {
        return this.primary.isDirectory();
    }

    public long lastModified() {
        return this.primary.lastModified();
    }

    public long length() {
        return this.primary.length();
    }

    public URL getURL() {
        return this.primary.getURL();
    }

    public File getFile() throws IOException {
        return this.primary.getFile();
    }

    public String getName() {
        return this.primary.getName();
    }

    public InputStream getInputStream() throws IOException {
        return this.primary.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        return this.primary.getOutputStream();
    }

    public boolean delete() throws SecurityException {
        return this.primary.delete();
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        return this.primary.renameTo(dest);
    }

    public String[] list() {
        return this.primary.list();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || ((Object)((Object)this)).getClass() != o2.getClass()) {
            return false;
        }
        MultiPathResource that = (MultiPathResource)((Object)o2);
        return this.primary.equals(that.primary);
    }

    public int hashCode() {
        return this.primary.hashCode();
    }

    public String toString() {
        return "Multi[" + this.primary.toString() + "]";
    }
}

