/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.jetty;

import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.jetty.MultiPathResource;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;

public class FishEyeWebApplicationContext
extends WebAppContext {
    public static ClassLoader webClassLoader;
    private File customContentDir;
    public static final String CURRENTSTATIC_PREFIX = "/currentstatic/";

    public FishEyeWebApplicationContext(HandlerCollection handlers, String path, String webcontext) {
        super((HandlerContainer)handlers, path, webcontext);
        SessionManager sm = this.getSessionHandler().getSessionManager();
        if (sm instanceof AbstractSessionManager) {
            AbstractSessionManager asm = (AbstractSessionManager)sm;
            asm.setHttpOnly(true);
        }
    }

    protected void doStart() throws Exception {
        Throwable exception;
        super.doStart();
        if (this.customContentDir != null) {
            Resource orig = this.getBaseResource();
            MultiPathResource c2 = new MultiPathResource(orig);
            c2.addOther(Resource.newResource((URL)this.customContentDir.toURI().toURL()));
            this.setBaseResource(c2);
        }
        if ((exception = super.getUnavailableException()) != null) {
            Logs.APP_LOG.error((Object)"The Web context could not be started", exception);
        }
    }

    public void setCustomContentDir(File customContentDir) {
        this.customContentDir = customContentDir;
    }

    public File getCustomContentDir() {
        return this.customContentDir;
    }

    public Resource getResource(String uriInContext) throws MalformedURLException {
        if (uriInContext != null && uriInContext.startsWith(CURRENTSTATIC_PREFIX)) {
            uriInContext = "/static/" + FisheyeVersionInfo.BUILD_STAMP + "/" + uriInContext.substring(CURRENTSTATIC_PREFIX.length());
        }
        return super.getResource(uriInContext.replace("\\", "/"));
    }

    public void setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        FishEyeWebApplicationContext.setWebClassLoader(classLoader);
    }

    private static void setWebClassLoader(ClassLoader classLoader) {
        webClassLoader = classLoader;
    }
}

