/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.atlassian.fecru.utils.HttpUtils;
import com.atlassian.fisheye.plugin.webresource.FisheyeWebResourceIntegration;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.web.filters.GlobalJspContextFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="upfrontFilter")
public class UpfrontFilter
implements Filter {
    public static final String GLOBAL = "global";
    private final GlobalJspContextFactory globalJspContextFactory;

    @Autowired
    public UpfrontFilter(GlobalJspContextFactory globalJspContextFactory) {
        this.globalJspContextFactory = globalJspContextFactory;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)req;
            this.fixupCharset(request);
            request.setAttribute(GLOBAL, (Object)this.globalJspContextFactory.make(request));
            FisheyeWebResourceIntegration.setContextPath(request);
            this.setStaticCacheHeaders(res, request);
            this.recordOriginalUrl(request);
            this.preventMSIECompatibilityMode((HttpServletResponse)res);
            chain.doFilter(req, res);
        }
    }

    private void preventMSIECompatibilityMode(HttpServletResponse httpResponse) {
        httpResponse.addHeader("X-UA-Compatible", "IE=Edge");
    }

    private void setStaticCacheHeaders(ServletResponse res, HttpServletRequest request) {
        String staticRequestPath = "/static/" + FisheyeVersionInfo.BUILD_STAMP;
        String actualRequestPath = request.getServletPath();
        if (actualRequestPath.indexOf(staticRequestPath) == 0) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)res;
            HttpUtils.addCacheHeaders(httpServletResponse, 31556925993L);
        }
    }

    private void recordOriginalUrl(HttpServletRequest request) {
        if (request.getAttribute("fisheye.forward.context_path") == null) {
            request.setAttribute("fisheye.forward.context_path", (Object)request.getContextPath());
        }
        if (request.getAttribute("fisheye.forward.request_uri") == null) {
            request.setAttribute("fisheye.forward.request_uri", (Object)request.getRequestURI());
        }
        if (request.getAttribute("fisheye.forward.query_string") == null) {
            request.setAttribute("fisheye.forward.query_string", (Object)request.getQueryString());
        }
    }

    private void fixupCharset(HttpServletRequest request) throws UnsupportedEncodingException {
        if (request.getMethod().equals("POST") && request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("UTF-8");
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

