/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.atlassian.fecru.gwt.admin.client.GlobalSettingsAdminRpcService;
import com.atlassian.fecru.gwt.admin.client.RepositoryAdminRpcService;
import com.atlassian.fecru.gwt.core.client.LoggingRPCService;
import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.AdminConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.LoginServlet;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.filters.AdminApiActionRewrite;
import com.cenqua.fisheye.web.filters.CommitterRedirectRewrite;
import com.cenqua.fisheye.web.filters.CrucibleActionRewrite;
import com.cenqua.fisheye.web.filters.JsonRewrite;
import com.cenqua.fisheye.web.filters.MaintenanceRewrite;
import com.cenqua.fisheye.web.filters.ProjectPageRewrite;
import com.cenqua.fisheye.web.filters.ProjectPermaidRewrite;
import com.cenqua.fisheye.web.filters.QuickSearchRewriteRule;
import com.cenqua.fisheye.web.filters.ReportsRewrite;
import com.cenqua.fisheye.web.filters.RepositoryPathToParametersRewrite;
import com.cenqua.fisheye.web.filters.RestRewriteRule;
import com.cenqua.fisheye.web.filters.ReviewPermaIdRewrite;
import com.cenqua.fisheye.web.filters.RewriteRule;
import com.cenqua.fisheye.web.filters.SimpleRegexRewriteRule;
import com.cenqua.fisheye.web.filters.SnippetRewrite;
import com.cenqua.fisheye.web.filters.UserPageRewrite;
import com.cenqua.fisheye.web.security.UserDetector;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.cenqua.fisheye.web.util.SessionIdUtil;
import com.cenqua.fisheye.web.util.WrappedRequest;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="totalityFilter")
public class TotalityFilter
implements Filter {
    public static final String X_AUSERNAME_HEADER = "X-AUSERNAME";
    public static final String X_ASESSION_HEADER = "X-ASESSIONID";
    private final List<RewriteRule> rules = new ArrayList<RewriteRule>();
    private static final ThreadLocal<Context> context = new ThreadLocal();
    private final EffectiveUserProviderImpl effectiveUserProvider;
    private final UserManager userManager;
    private final LicenseManager licenseManager;
    private final PreferenceManager preferenceManager;
    private final UserDetector userDetector;

    @Autowired
    public TotalityFilter(EffectiveUserProviderImpl effectiveUserProvider, UserManager userManager, LicenseManager licenseManager, PreferenceManager preferenceManager, UserDetector userDetector) {
        this.effectiveUserProvider = effectiveUserProvider;
        this.userManager = userManager;
        this.licenseManager = licenseManager;
        this.preferenceManager = preferenceManager;
        this.userDetector = userDetector;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.rules.add(new JsonRewrite());
        this.rules.add(new AdminApiActionRewrite());
        this.rules.add(new QuickSearchRewriteRule());
        this.rules.add(new UserPageRewrite());
        this.rules.add(new CommitterRedirectRewrite());
        this.rules.add(new ProjectPageRewrite());
        this.rules.add(new ReportsRewrite());
        SimpleRegexRewriteRule avatar = new SimpleRegexRewriteRule("^/avatar/([^/]*)$", "/action/avatar.do");
        avatar.addParameter(1, "username");
        this.rules.add(avatar);
        this.rules.add(new SimpleRegexRewriteRule("^/changelog/?$", "/showactivitypage"));
        this.rules.add(new SimpleRegexRewriteRule("^/?home/?$", "/fe/home.do"));
        SimpleRegexRewriteRule userListRewriteRule = new SimpleRegexRewriteRule("^/?users?(/.+)$", "/fe/listUsersForRepository.do");
        userListRewriteRule.addParameter(1, "p");
        this.rules.add(userListRewriteRule);
        this.rules.add(new SimpleRegexRewriteRule("^/?users?/?$", "/fe/listUsers.do"));
        this.rules.add(new SimpleRegexRewriteRule("^/?committers?/?$", "/fe/listUsers.do"));
        this.rules.add(new SimpleRegexRewriteRule("^/people/?$", "/fe/listUsers.do"));
        this.rules.add(new SimpleRegexRewriteRule("^/browse/?$", "/fe/listRepositories.do"));
        this.rules.add(new RepositoryPathToParametersRewrite("graph", "/fe/viewRepositoryGraph.do"));
        this.rules.add(new SnippetRewrite());
        this.rules.add(new ReviewPermaIdRewrite());
        this.rules.add(new ProjectPermaidRewrite());
        this.rules.add(new CrucibleActionRewrite());
        this.rules.add(new MaintenanceRewrite());
        this.rules.add(new RestRewriteRule());
        this.rules.add(new RewriteRule(Pattern.compile("^/rest/api/1\\.0/rest-service-fe/(server-v1(.json|.xml)?)$")){

            @Override
            public String rewrite(Matcher match, WrappedRequest req) {
                return "/rest/api/1.0/rest-service-fecru/" + match.group(1);
            }
        });
    }

    public static HttpServletRequest getRequest() {
        return TotalityFilter.getContext().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return TotalityFilter.getContext().getResponse();
    }

    public static boolean isInRequest() {
        return context.get() != null;
    }

    private static Context getContext() {
        Context c2 = context.get();
        if (c2 == null) {
            throw new IllegalStateException("Called getContext outside request");
        }
        return c2;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        TotalityFilter.addSessionHashHeader(req, resp);
        String url = ServletUtils.getPostContextPath(req);
        url = FishEyeURLEncoder.pathEncode(url);
        WrappedRequest wr = new WrappedRequest(req);
        Context oldContext = context.get();
        try {
            context.set(new Context((HttpServletRequest)wr, resp));
            boolean redirectRequired = false;
            for (RewriteRule rule : this.rules) {
                String rewrite;
                Matcher matcher = rule.applyRule(url);
                if (matcher == null || (rewrite = rule.rewrite(matcher, wr)) == null) continue;
                url = rewrite;
                redirectRequired = true;
            }
            if (redirectRequired) {
                wr.getRequestDispatcher(url).forward((ServletRequest)wr, (ServletResponse)resp);
                return;
            }
            if (!TotalityFilter.isSetupUrl(url) && !TotalityFilter.isStaticContent(url)) {
                boolean requireSetup = this.requiresSetup();
                if (requireSetup) {
                    if (this.isRequiredByJaacs(url)) {
                        filterChain.doFilter((ServletRequest)wr, (ServletResponse)resp);
                        return;
                    }
                    resp.sendRedirect(wr.getContextPath() + "/setup/welcome.do");
                    return;
                }
                if (!TotalityFilter.isAdminLicensingUrl(url) && this.missingLicenseOrGracePeriodExpired()) {
                    resp.sendRedirect(wr.getContextPath() + "/admin/editLicense-default.do");
                    return;
                }
            }
            if (TotalityFilter.isStaticContent(url) || TotalityFilter.isNoUserCheck(url)) {
                filterChain.doFilter((ServletRequest)wr, (ServletResponse)resp);
                return;
            }
            boolean goToLoginDueToError = false;
            UserLogin user = null;
            try {
                user = this.userDetector.process((HttpServletRequest)wr, resp);
            }
            catch (LicensePolicyException e2) {
                Logs.APP_LOG.warn((Object)("problem authenticating user: " + e2.getMessage()));
                wr.setAttribute("errormsg", e2.getMessage());
                goToLoginDueToError = true;
            }
            this.addUserDataToRequest((ServletRequest)req, user);
            TotalityFilter.addUsernameHeader(resp, user);
            if ((goToLoginDueToError || this.requiresLogin(user)) && !this.isOutsideLogin(url)) {
                if (url.startsWith("/gwt")) {
                    Logs.APP_LOG.warn((Object)("Unexpected redirect to login for gwt url '" + url + "'"));
                }
                LoginServlet.redirectToLogin((HttpServletRequest)wr, resp);
                return;
            }
            if (!this.isOutsideLogin(url)) {
                try {
                    if (this.licenseManager.getExcessFEUsers() > 0 || this.licenseManager.getExcessCruUsers() > 0) {
                        resp.sendRedirect(wr.getContextPath() + "/fecru/licenseExceeded.do");
                        return;
                    }
                }
                catch (DbException e3) {
                    Logs.APP_LOG.debug((Object)"Could not read users from database", (Throwable)e3);
                    throw new IOException("Could not read users from database");
                }
            }
            this.preferenceManager.doFilter((HttpServletRequest)wr, resp);
            this.setCachingHeaders(user, resp);
            if (TotalityFilter.isSetupUrl(url)) {
                filterChain.doFilter((ServletRequest)wr, (ServletResponse)resp);
                return;
            }
            FecruUser crucibleUser = this.getCurrentUser(user);
            this.effectiveUserProvider.pushEffectivePrincipal(user, crucibleUser);
            try {
                filterChain.doFilter((ServletRequest)wr, (ServletResponse)resp);
            }
            finally {
                try {
                    this.effectiveUserProvider.popEffectivePrincipal();
                }
                catch (Exception e4) {
                    Logs.APP_LOG.error((Object)"Error popping principal", (Throwable)e4);
                }
            }
        }
        catch (IOException | RuntimeException | ServletException ioe) {
            TotalityFilter.logExceptionDetails(req, (Exception)ioe);
            throw ioe;
        }
        finally {
            context.set(oldContext);
        }
    }

    private static void addUsernameHeader(HttpServletResponse resp, UserLogin user) {
        if (!resp.containsHeader(X_AUSERNAME_HEADER)) {
            resp.addHeader(X_AUSERNAME_HEADER, user == null ? "anonymous" : FishEyeURLEncoder.uriEncode(user.getUserName()));
        }
    }

    private static void addSessionHashHeader(HttpServletRequest req, HttpServletResponse resp) {
        String sessionHash;
        if (!resp.containsHeader(X_ASESSION_HEADER) && (sessionHash = SessionIdUtil.generateAtlassianSessionHash(req, resp)) != null) {
            resp.addHeader(X_ASESSION_HEADER, sessionHash);
        }
    }

    private void addUserDataToRequest(ServletRequest req, UserLogin user) {
        if (user == null) {
            return;
        }
        while (req instanceof ServletRequestWrapper) {
            req = ((ServletRequestWrapper)req).getRequest();
        }
        if (req instanceof Request) {
            String authMethod = user.getAuthType() != null ? user.getAuthType().toString() : "";
            ((Request)req).setAuthentication((Authentication)new UserAuthentication(authMethod, (UserIdentity)new DefaultUserIdentity(new Subject(), (java.security.Principal)user, new String[0])));
        }
    }

    private static void logExceptionDetails(HttpServletRequest req, Exception ex) {
        Logs.APP_LOG.error((Object)("Exception \"" + ex.getMessage() + "\" (" + ex.getClass().getName() + ") while processing \"" + ServletUtils.getSanitisedURL(req) + "\" (Referer:\"" + ServletUtils.getSanitisedReferer(req) + "\")"), (Throwable)ex);
    }

    @VisibleForTesting
    protected boolean missingLicenseOrGracePeriodExpired() {
        RootConfig rootConfig = AppConfig.getsConfig();
        LicenseInfo licenseInfo = rootConfig.getLicense();
        return licenseInfo == null || licenseInfo.isGracePeriodExpired();
    }

    private FecruUser getCurrentUser(UserLogin login) {
        if (login == null) {
            return null;
        }
        return this.userManager.getUser(login.getUsername());
    }

    private boolean requiresLogin(UserLogin user) {
        if (user != null) {
            return false;
        }
        RootConfig root = AppConfig.getsConfig();
        return !root.getConfig().getSecurity().getAllowAnon();
    }

    private void setCachingHeaders(UserLogin user, HttpServletResponse response) {
        if (user != null) {
            response.setHeader("Cache-Control", "private");
        }
    }

    @VisibleForTesting
    protected boolean requiresSetup() {
        RootConfig rootConfig = AppConfig.getsConfig();
        AdminConfig acfg = rootConfig.getAdminConfig();
        return !acfg.haveDoneInitialSetup();
    }

    private boolean isOutsideLogin(String path) {
        return TotalityFilter.isStaticContent(path) || TotalityFilter.isSetupUrl(path) || path.startsWith("/admin/") || path.equals("/admin") || TotalityFilter.isAdminGWTService(path) || path.equals("/login") || path.startsWith("/login/") || path.startsWith("/download/") || path.startsWith("/action/avatar.do") || this.handlesOwnSecurity(path) || path.equals("/logout") || path.equals("/fecru/licenseExceeded.do");
    }

    private boolean handlesOwnSecurity(String path) {
        return path.startsWith("/api") || path.startsWith("/rest-service/") || path.startsWith("/rest-service-fe/") || path.startsWith("/service/") || path.startsWith("/plugins/servlet/") || path.startsWith("/rest");
    }

    private static boolean isAdminGWTService(String path) {
        return path.startsWith("/gwt/" + RepositoryAdminRpcService.class.getSimpleName()) || path.startsWith("/gwt/" + LoggingRPCService.class.getSimpleName()) || path.startsWith("/gwt/" + GlobalSettingsAdminRpcService.class.getSimpleName());
    }

    public static boolean isSetupUrl(String path) {
        return path.startsWith("/setup");
    }

    private boolean isRequiredByJaacs(String url) {
        return TotalityFilter.isRestUrl(url) || TotalityFilter.isRequestForTrustedAppsCertificate(url) || TotalityFilter.isAppLinksRestManifestUrl(url);
    }

    private static boolean isRequestForTrustedAppsCertificate(String path) {
        return path.equals("/admin/appTrustCertificate");
    }

    private static boolean isAppLinksRestManifestUrl(String path) {
        return path.startsWith("/rest/applinks/") && path.endsWith("/manifest");
    }

    private static boolean isRestUrl(String path) {
        return path.startsWith("/api/rest") || path.startsWith("/rest/api");
    }

    private static boolean isAdminLicensingUrl(String path) {
        return path.startsWith("/admin/editLicense") || path.startsWith("/admin/login") || path.startsWith("/login") || TotalityFilter.isAdminGWTService(path);
    }

    public static boolean isStaticContent(String path) {
        return path.startsWith("/WEB-INF/") || path.equals("/favicon.ico") || path.startsWith("/static/") || path.startsWith("/download/");
    }

    public static boolean isNoUserCheck(String path) {
        return path.startsWith("/setup/migrateDBProgressAjax") || path.startsWith("/admin/performBackup-progress.do");
    }

    private static EffectiveUserProvider getEffectiveUserProvider() {
        return SpringContext.getComponent(EffectiveUserProviderImpl.class, "effectiveUserProvider");
    }

    @Deprecated
    public static FecruUser getCurrentUser() {
        return TotalityFilter.getEffectiveUserProvider().getEffectiveUser();
    }

    @Deprecated
    public static Principal getCurrentPrincipal() {
        return TotalityFilter.getEffectiveUserProvider().getEffectivePrincipal();
    }

    private static class Context {
        private final HttpServletRequest request;
        private final HttpServletResponse response;

        public Context(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }
    }
}

