/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.cenqua.fisheye.web.filters.RewriteRule;
import com.cenqua.fisheye.web.util.WrappedRequest;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SnippetRewrite
extends RewriteRule {
    private static final Pattern PROG = Pattern.compile("^/snippet/(.*)$");
    private static final Pattern CREATE_SNIPPET = Pattern.compile("^create(-modify)?$");
    public static final String SNIPPET_REWRITE_PASS = "snippet-rewrite-pass";

    public SnippetRewrite() {
        super(PROG);
    }

    @Override
    public String rewrite(Matcher match, WrappedRequest req) {
        req.setAttribute(SNIPPET_REWRITE_PASS, Boolean.TRUE);
        String rest = match.group(1);
        Matcher createMatcher = CREATE_SNIPPET.matcher(rest);
        if (createMatcher.matches()) {
            return "/cru/createSnippet" + Strings.nullToEmpty((String)createMatcher.group(1));
        }
        return "/cru/" + rest;
    }
}

