/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.cenqua.fisheye.web.filters.RewriteRule;
import com.cenqua.fisheye.web.util.WrappedRequest;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleRegexRewriteRule
extends RewriteRule {
    private final String redirectTo;
    private Object2IntMap<String> extraParams;

    public SimpleRegexRewriteRule(String regex, String redirectTo) {
        super(Pattern.compile(regex));
        this.redirectTo = redirectTo;
    }

    @Override
    public String rewrite(Matcher match, WrappedRequest req) {
        this.addParams(match, req);
        return this.redirectTo;
    }

    private void addParams(Matcher match, WrappedRequest req) {
        if (this.extraParams == null) {
            return;
        }
        for (String param : this.extraParams.keySet()) {
            String value;
            int group = (Integer)this.extraParams.get((Object)param);
            if (group > match.groupCount() || (value = match.group(group)) == null) continue;
            req.setParameter(param, value);
        }
    }

    public void addParameter(int group, String paramName) {
        if (this.extraParams == null) {
            this.extraParams = new Object2IntOpenHashMap();
        }
        this.extraParams.put((Object)paramName, group);
    }

    public String toString() {
        return "RewriteRule:" + this.redirectTo;
    }
}

