/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecurityHeadersFilter
implements Filter {
    private static final List<Pattern> xFrameHeaderBlacklistUrls = ImmutableList.of((Object)Pattern.compile("/plugins/servlet/.*"), (Object)Pattern.compile(Pattern.quote("/admin/login-default.do")), (Object)Pattern.compile(Pattern.quote("/admin/login.do")), (Object)Pattern.compile("/login(/.*)?"));

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        res.setHeader("X-Content-Type-Options", "nosniff");
        res.setHeader("X-XSS-Protection", "1; mode=block");
        if (this.isXFrameHeaderAllowedToBeAdded(req)) {
            res.setHeader("X-Frame-Options", "SAMEORIGIN");
        }
        chain.doFilter(request, response);
    }

    private boolean isXFrameHeaderAllowedToBeAdded(HttpServletRequest request) {
        String url = request.getServletPath() + Strings.nullToEmpty((String)request.getPathInfo());
        for (Pattern pattern : xFrameHeaderBlacklistUrls) {
            if (!pattern.matcher(url).matches()) continue;
            return false;
        }
        return true;
    }

    public void destroy() {
    }
}

