/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.cenqua.crucible.model.Project;
import com.cenqua.fisheye.web.filters.RewriteRule;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.cenqua.fisheye.web.util.WrappedRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class ReviewPermaIdRewrite
extends RewriteRule {
    public static final String PARAM_COMMAND = "command";
    public static final String XML_HTTP_REQUEST = "XMLHttpRequest";
    private static final Pattern PERMAID_PROG = Pattern.compile("^/?cru/([A-Z0-9\\-]+)-(\\d{1,9})(?:/([^/]+)(/.+)?)?/?$", 2);

    public ReviewPermaIdRewrite() {
        super(PERMAID_PROG);
    }

    @Override
    public String rewrite(Matcher match, WrappedRequest ra) {
        String command;
        String pKey = Project.upperCaseProjectKey(match.group(1));
        String rNum = match.group(2);
        String action = match.group(3);
        String pathinfo = match.group(4);
        if (action == null) {
            action = "review";
        }
        if ((command = ra.getParameter(PARAM_COMMAND)) != null && !this.isAjaxRequest((HttpServletRequest)ra)) {
            action = action + "-" + command;
        }
        String desturl = "/cru/" + action + ".do";
        ra.setParameter("permaKeyNumber", rNum);
        ra.setParameter("permaKeyProject", pKey);
        if (pathinfo != null) {
            ra.setParameter("actionPathInfo", FishEyeURLEncoder.decode(pathinfo));
        }
        return desturl;
    }

    private boolean isAjaxRequest(HttpServletRequest req) {
        return XML_HTTP_REQUEST.equals(req.getHeader("X-Requested-With"));
    }

    public static String getClosestGETUrl(String permIdUrl) {
        Matcher matcher = PERMAID_PROG.matcher(permIdUrl);
        if (matcher.matches()) {
            String pKey = Project.upperCaseProjectKey(matcher.group(1));
            String rNum = matcher.group(2);
            return "/cru/" + pKey + "-" + rNum;
        }
        return null;
    }
}

