/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.cenqua.fisheye.web.filters.RewriteRule;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.cenqua.fisheye.web.util.WrappedRequest;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RepositoryPathToParametersRewrite
extends RewriteRule {
    private static final int REPO_GROUP = 1;
    private static final int PATH_GROUP = 2;
    private final String rewriteUrl;

    public RepositoryPathToParametersRewrite(String action, String rewriteUrl) {
        super(Pattern.compile("^/?" + action + "/" + "([^/]+)" + "(/.*)?" + "$"));
        this.rewriteUrl = rewriteUrl;
    }

    @Override
    public String rewrite(Matcher match, WrappedRequest req) {
        this.setParameter(req, "repoName", match.group(1));
        this.setParameter(req, "path", match.group(2));
        return this.rewriteUrl;
    }

    private void setParameter(WrappedRequest req, String parameter, String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            req.setParameter(parameter, RepositoryPathToParametersRewrite.uriDecode(value));
        }
    }

    private static String uriDecode(String s2) {
        return FishEyeURLEncoder.decode(s2);
    }
}

