/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.cenqua.fisheye.web.filters.RewriteRule;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.cenqua.fisheye.web.util.WrappedRequest;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class QuickSearchRewriteRule
extends RewriteRule {
    protected static final String TARGET_URL = "/fe/quicksearch.do";
    private static final Pattern REWRITE_RULE = Pattern.compile("^/qsearch(?:/(\\S*))?$");

    public QuickSearchRewriteRule() {
        super(REWRITE_RULE);
    }

    @Override
    public String rewrite(Matcher match, WrappedRequest request) {
        String repository = match.group(1);
        if (!Strings.isNullOrEmpty((String)repository)) {
            request.setParameter("repository", FishEyeURLEncoder.decode(repository));
        }
        return TARGET_URL;
    }
}

