/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.cenqua.crucible.model.Project;
import com.cenqua.fisheye.web.filters.RewriteRule;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.cenqua.fisheye.web.util.WrappedRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProjectPermaidRewrite
extends RewriteRule {
    private static final Pattern PERMAID_PROG = Pattern.compile("^/?cru/browse/([A-Z0-9\\-]+)(?:/([^/]+)(/.+)?)?/?$", 2);

    public ProjectPermaidRewrite() {
        super(PERMAID_PROG);
    }

    @Override
    public String rewrite(Matcher match, WrappedRequest req) {
        String pKey = Project.upperCaseProjectKey(match.group(1));
        String action = match.group(2);
        String pathinfo = match.group(3);
        if (action == null) {
            action = "project";
        }
        String desturl = "/cru/" + action + ".do";
        req.setParameter("projectKey", pKey);
        if (pathinfo != null) {
            req.setParameter("actionPathInfo", FishEyeURLEncoder.decode(pathinfo));
        }
        return desturl;
    }
}

