/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.atlassian.crucible.maintenance.MaintenanceManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.filters.JsonRewrite;
import com.cenqua.fisheye.web.filters.RewriteRule;
import com.cenqua.fisheye.web.filters.TotalityFilter;
import com.cenqua.fisheye.web.util.WrappedRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class MaintenanceRewrite
extends RewriteRule {
    private static final Pattern PREFIX_PROG = Pattern.compile("(?!/?admin).*");
    private static final String MAINTENANCE_PAGE = "/WEB-INF/jsp/common/maintenance.jsp";
    private static final String MAINTENANCE_PAGE_JSON = "/WEB-INF/jsp/common/maintenance_json.jsp";
    private MaintenanceManager maintenanceManager = null;

    public MaintenanceRewrite() {
        super(PREFIX_PROG);
    }

    private MaintenanceManager getMaintenanceManager() {
        if (this.maintenanceManager == null) {
            this.maintenanceManager = (MaintenanceManager)SpringContext.getComponent("maintenanceManager");
        }
        return this.maintenanceManager;
    }

    @Override
    public Matcher applyRule(String url) {
        Matcher matcher = super.applyRule(url);
        if (matcher != null && !TotalityFilter.isStaticContent(url) && !TotalityFilter.isSetupUrl(url) && this.getMaintenanceManager().isDownForMaintenance()) {
            Logs.APP_LOG.debug((Object)(this.getMaintenanceManager().getMessage() + " Redirecting to maintenance page."));
            return matcher;
        }
        return null;
    }

    @Override
    public String rewrite(Matcher match, WrappedRequest req) {
        if (JsonRewrite.isAjaxRequest((HttpServletRequest)req)) {
            return MAINTENANCE_PAGE_JSON;
        }
        return MAINTENANCE_PAGE;
    }
}

