/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.plugin.webresource.FisheyeWebResourceManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.web.filters.GlobalJspContext;
import com.cenqua.fisheye.web.filters.MessageSource;
import com.cenqua.fisheye.web.soy.SoyRenderer;
import com.cenqua.fisheye.web.util.PluginModuleInstanceTracker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GlobalJspContextFactory {
    private final FisheyeWebResourceManager webResourceManager;
    private final Collection<MessageSource> sources;
    private final EffectiveUserProvider effectiveUserProvider;
    private final Mailer mailer;
    private final PluginAccessor pluginAccessor;
    private final SoyRenderer soyRenderer;
    private final RootConfig rootConfig;
    private final SecureProjectManager secureProjectManager;
    private final LicenseManager licenseManager;
    private final PluginModuleInstanceTracker<MessageSource> pluginSourcesTracker;

    @Autowired
    public GlobalJspContextFactory(FisheyeWebResourceManager webResourceManager, Collection<MessageSource> sources, EffectiveUserProvider effectiveUserProvider, Mailer mailer, PluginAccessor accessor, SoyRenderer soyRenderer, RootConfig rootConfig, SecureProjectManager secureProjectManager, LicenseManager licenseManager, PluginEventManager pluginEventManager) {
        this.webResourceManager = webResourceManager;
        this.sources = sources;
        this.effectiveUserProvider = effectiveUserProvider;
        this.mailer = mailer;
        this.pluginAccessor = accessor;
        this.soyRenderer = soyRenderer;
        this.rootConfig = rootConfig;
        this.secureProjectManager = secureProjectManager;
        this.licenseManager = licenseManager;
        this.pluginSourcesTracker = new PluginModuleInstanceTracker<MessageSource>(this.pluginAccessor, pluginEventManager, MessageSource.class);
    }

    public GlobalJspContext make(HttpServletRequest request) {
        Iterable springAndPluginSources = Iterables.concat(this.sources, this.pluginSourcesTracker.getModules());
        return new GlobalJspContext(request, this.webResourceManager, (Collection<MessageSource>)ImmutableList.copyOf((Iterable)springAndPluginSources), this.effectiveUserProvider, this.mailer, this.pluginAccessor, this.soyRenderer, this.rootConfig, this.secureProjectManager, this.licenseManager);
    }
}

