/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fisheye.plugin.webresource.FisheyeWebResourceManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.security.random.DefaultSecureRandomService;
import com.atlassian.security.random.SecureRandomService;
import com.cenqua.crucible.CrucibleVersionInfo;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.config.CustomContent;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.HttpServerType;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.web.ActionDispatcherServlet;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.filters.JsonRewrite;
import com.cenqua.fisheye.web.filters.MessageSource;
import com.cenqua.fisheye.web.filters.SystemMessage;
import com.cenqua.fisheye.web.soy.SoyRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;

public class GlobalJspContext {
    private final HttpServletRequest request;
    private final FisheyeWebResourceManager webResourceManager;
    private final Collection<MessageSource> sources;
    private final EffectiveUserProvider effectiveUserProvider;
    private final Mailer mailer;
    private final PluginAccessor pluginAccessor;
    private final SoyRenderer soyRenderer;
    private final RootConfig rootConfig;
    private final String siteUrl;
    private final long tsBeginProcessing = System.currentTimeMillis();
    private final FisheyeVersionInfo fisheyeVersionInfo = new FisheyeVersionInfo();
    private final CrucibleVersionInfo crucibleVersionInfo = new CrucibleVersionInfo();
    private final CustomContent customContent = new CustomContent();
    private final String staticContextPath;
    private final SecureRandomService random = DefaultSecureRandomService.getInstance();
    private final SecureProjectManager secureProjectManager;
    private final LicenseManager licenseManager;
    private List<SystemMessage> messagesCache = null;
    public static final String HEAD_OF_BRANCH_PARAM = "hb";
    private final String threadName;
    private Boolean isJiraIssueCreationPluginEnabled;
    private Boolean isJiraIntegrationPluginEnabled;
    private Boolean showCreateReview;
    private TimeZone timeZone;

    public GlobalJspContext(HttpServletRequest request, FisheyeWebResourceManager webResourceManager, Collection<MessageSource> sources, EffectiveUserProvider effectiveUserProvider, Mailer mailer, PluginAccessor pluginAccessor, SoyRenderer soyRenderer, RootConfig rootConfig, SecureProjectManager secureProjectManager, LicenseManager licenseManager) {
        this.request = request;
        this.webResourceManager = webResourceManager;
        this.sources = sources;
        this.effectiveUserProvider = effectiveUserProvider;
        this.mailer = mailer;
        this.pluginAccessor = pluginAccessor;
        this.soyRenderer = soyRenderer;
        this.rootConfig = rootConfig;
        this.secureProjectManager = secureProjectManager;
        this.licenseManager = licenseManager;
        this.siteUrl = ServletUtils.getBaseUrl(request);
        this.staticContextPath = request.getContextPath() + "/" + ActionDispatcherServlet.STATIC_DIR;
        this.threadName = Thread.currentThread().getName();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getStaticContextPath() {
        return this.staticContextPath;
    }

    public String getSiteUrl() {
        return this.siteUrl;
    }

    public String getStaticDir() {
        return ActionDispatcherServlet.STATIC_DIR;
    }

    public long getTsBeginProcessing() {
        return this.tsBeginProcessing;
    }

    public long getMsSinceRequestBegan() {
        return System.currentTimeMillis() - this.tsBeginProcessing;
    }

    public boolean isCrucible() {
        return AppConfig.isCrucible();
    }

    public boolean isCrucibleOnly() {
        return AppConfig.isCrucibleOnly();
    }

    public boolean isFishEye() {
        return !this.isCrucibleOnly();
    }

    public boolean isFishEyeOnly() {
        return AppConfig.isFishEyeOnly();
    }

    public boolean isFisheyeDownload() {
        return AppConfig.isFisheyeDownload();
    }

    public boolean isCrucibleDownload() {
        return AppConfig.isCrucibleDownload();
    }

    public String getProductName() {
        return AppConfig.getProductName();
    }

    public FisheyeVersionInfo getFisheyeVersionInfo() {
        return this.fisheyeVersionInfo;
    }

    public CrucibleVersionInfo getCrucibleVersionInfo() {
        return this.crucibleVersionInfo;
    }

    public CustomContent getCustomContent() {
        return this.customContent;
    }

    public boolean isJsonRequest() {
        return JsonRewrite.isAjaxRequest(this.request);
    }

    public UserLogin getUserLogin() {
        return this.effectiveUserProvider.getEffectiveUserLogin();
    }

    public UserProfile getUserProfile() throws DbException {
        FecruUser user = this.effectiveUserProvider.getEffectiveUser();
        if (user == null) {
            return UserProfileManager.DEFAULT_PROFILE;
        }
        return user.getUserProfile();
    }

    public int getRandom() {
        return this.random.nextInt();
    }

    public FisheyeWebResourceManager getWebResourceManager() {
        return this.webResourceManager;
    }

    public List<SystemMessage> getSystemMessages() {
        if (this.messagesCache == null) {
            this.messagesCache = new ArrayList<SystemMessage>();
            for (MessageSource source : this.sources) {
                this.messagesCache.addAll(source.getMessages(this.request));
            }
        }
        return this.messagesCache;
    }

    public ConfigDocument.Config getConfig() {
        return AppConfig.getsConfig().getConfig();
    }

    public int getTimeZoneOffset() {
        return GlobalJspContext.getTimeZoneOffset(this.getTimeZone(), new Date());
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = this.effectiveUserProvider.getEffectiveTimezone();
        }
        return this.timeZone;
    }

    static int getTimeZoneOffset(TimeZone tz, Date asOfWhen) {
        return (int)((long)tz.getOffset(asOfWhen.getTime()) / 60000L);
    }

    public String getHeadOfBranchParam() {
        return HEAD_OF_BRANCH_PARAM;
    }

    public boolean isSecure() {
        if (this.request.isSecure()) {
            return true;
        }
        HttpServerType httpServerType = AppConfig.getsConfig().getConfig().getWebServer().getHttp();
        return httpServerType != null && httpServerType.isSetProxyScheme() && httpServerType.getProxyScheme().toLowerCase(Locale.US).startsWith("https");
    }

    public boolean isMailerConfigured() {
        return this.mailer.isConfigured();
    }

    public String getPageInfo() {
        return "Page produced in " + this.getMsSinceRequestBegan() + " ms on " + this.threadName;
    }

    public boolean isJiraIssueCreationPluginEnabled() {
        if (this.isJiraIssueCreationPluginEnabled == null) {
            this.isJiraIssueCreationPluginEnabled = this.pluginAccessor.getEnabledPluginModule("com.atlassian.crucible.plugins.jira-ril:jira-ril-service") != null;
        }
        return this.isJiraIssueCreationPluginEnabled;
    }

    public boolean isJiraIntegrationPluginEnabled() {
        if (this.isJiraIntegrationPluginEnabled == null) {
            this.isJiraIntegrationPluginEnabled = this.pluginAccessor.isPluginEnabled("com.atlassian.integration.jira.jira-integration-plugin");
        }
        return this.isJiraIntegrationPluginEnabled;
    }

    public boolean isSelectionHistoryEnabled() {
        return FishEyeSysProps.SELECTION_HISTORY;
    }

    public SoyRenderer getSoyRenderer() {
        return this.soyRenderer;
    }

    public RootConfig getRootConfig() {
        return this.rootConfig;
    }

    public boolean isShowCreateReview() {
        if (this.showCreateReview == null) {
            this.showCreateReview = this.isCrucible() && this.secureProjectManager.isAtLeastOneProjectCanDoActionIn(this.effectiveUserProvider.getEffectivePrincipal(), UserActionManager.Action.ACTION_CREATE);
        }
        return this.showCreateReview;
    }

    public LicenseManager getLicenseManager() {
        return this.licenseManager;
    }
}

