/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.web.ServletUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CommonRestFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.doFisheyeFilter(request, response) || !this.doCrucibleFilter(request, response)) {
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private boolean doCrucibleFilter(ServletRequest request, ServletResponse response) throws IOException {
        String path;
        if (!AppConfig.isCrucible() && request instanceof HttpServletRequest && ((path = ((HttpServletRequest)request).getRequestURI()).contains("/rest-service-fecru/recently-visited-v1/reviews") || path.contains("/rest-service-fecru/recently-visited-v1/snippets"))) {
            ServletUtils.send404((HttpServletRequest)request, (HttpServletResponse)response, "Crucible is not enabled");
            return false;
        }
        return true;
    }

    private boolean doFisheyeFilter(ServletRequest request, ServletResponse response) throws IOException {
        String path;
        if (!AppConfig.isFishEye() && request instanceof HttpServletRequest && (path = ((HttpServletRequest)request).getRequestURI()).contains("/rest-service-fecru/recently-visited-v1/repositories")) {
            ServletUtils.send404((HttpServletRequest)request, (HttpServletResponse)response, "Fisheye is not enabled");
            return false;
        }
        return true;
    }
}

