/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.cenqua.fisheye.web.filters.RewriteRule;
import com.cenqua.fisheye.web.util.WrappedRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AdminApiActionRewrite
extends RewriteRule {
    private static final Pattern ACTION_PROG = Pattern.compile("^/?admin-api(?:/repository/([^/]+))?(?:/([^/.]+)(?<!\\.do))(/.*)?$");

    public AdminApiActionRewrite() {
        super(ACTION_PROG);
    }

    @Override
    public String rewrite(Matcher match, WrappedRequest ra) {
        String repname = match.group(1);
        String action = match.group(2);
        String pathinfo = match.group(3);
        if (repname != null) {
            action = "repository-" + action;
            ra.setParameter("repname", repname);
        }
        action = ra.getMethod() + "-" + action;
        String desturl = "/admin-api/" + action + ".do";
        if (pathinfo != null) {
            ra.setParameter("actionPathInfo", pathinfo);
        }
        return desturl;
    }
}

