/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filehist;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.selectionhistory.PerLineHistoryCalculator;
import com.cenqua.fisheye.rep.selectionhistory.PerLineHistoryResult;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.cenqua.fisheye.web.parameterbeans.BaseFishEyeServletParams;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class PerLineHistoryAction
extends BaseAction {
    @Resource
    private final PerLineHistoryCalculator perLineHistoryCalculator;
    private RepositoryEngine engine;
    private int iframeHeight = 500;
    private String revision;
    private int fromLine;
    private int toLine;
    private List<PerLineHistoryResult.Revision> revisions;

    public PerLineHistoryAction(PerLineHistoryCalculator perLineHistoryCalculator) {
        this.perLineHistoryCalculator = perLineHistoryCalculator;
    }

    @Override
    public void setup() {
        this.engine = this.getPathInfo().getEngine();
    }

    @Override
    public BaseAction handleRequest(BaseActionParams baseParams) throws ServletException, IOException, DbException {
        HttpServletRequest req = this.getRequest();
        Path localPath = this.getPathInfo().getLocalPath();
        String revision = req.getParameter("r");
        int fromLine = this.getIntFromParam(req, "from");
        int toLine = this.getIntFromParam(req, "to");
        this.iframeHeight = this.getIntFromParam(req, "iframeHeight");
        List<PerLineHistoryResult.Revision> revisions = this.perLineHistoryCalculator.getRevisions(this.engine, localPath, revision, fromLine, toLine);
        this.revision = revision;
        this.fromLine = fromLine;
        this.toLine = toLine;
        this.revisions = revisions;
        BaseFishEyeServletParams params = new BaseFishEyeServletParams(baseParams);
        params.setFpath(this.getPathInfo().getFullPath());
        params.setPath(this.getPathInfo().getLocalPath());
        params.setRepositoryExplorer(new FisheyeRepositoryExplorer(this.engine, this.getPathInfo().getLocalPath(), new WaybackSpec(), this.getUserPreferences()));
        req.setAttribute("p", (Object)params);
        req.setAttribute("action", (Object)this);
        req.getRequestDispatcher("/WEB-INF/jsp/per-line-history.jsp").forward((ServletRequest)req, (ServletResponse)this.getResponse());
        return null;
    }

    private int getIntFromParam(HttpServletRequest request, String name) {
        try {
            return Integer.parseInt(request.getParameter(name));
        }
        catch (NumberFormatException e2) {
            throw new IllegalArgumentException(name + " parameter must be an integer, but was " + request.getParameter(name));
        }
    }

    public String getRevision() {
        return this.revision;
    }

    public int getFromLine() {
        return this.fromLine;
    }

    public int getToLine() {
        return this.toLine;
    }

    public List<PerLineHistoryResult.Revision> getRevisions() {
        return this.revisions;
    }

    public PerLineHistoryResult.Revision getFirstRevision() {
        return this.revisions.isEmpty() ? null : this.revisions.get(0);
    }

    public int getIframeHeight() {
        return this.iframeHeight;
    }
}

