/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filehist;

import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.parameterbeans.ViewFileActionParams;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class FisheyeRevisionTableData {
    private final List<FileRevision> revisions;
    private Set<FileRevision> uniqueRevisions;
    private final String repName;
    private final ScmType repType;
    private final String path;
    private String firstRevision = null;
    private final boolean supportsBranchFilter;
    private final boolean supportsCommitGraph;
    private String selectedBranch;
    @Nullable
    private final String defaultBranch;

    public FisheyeRevisionTableData(ViewFileActionParams params, FisheyeRepositoryExplorer repository) {
        this(params, repository, Collections.emptySet());
    }

    public FisheyeRevisionTableData(ViewFileActionParams params, FisheyeRepositoryExplorer repository, Set<Integer> revisionsOfInterest) {
        this.path = params.getPath().getPath();
        this.repName = repository.getRepName();
        RepositoryConfig repositoryConfig = repository.getEngine().getCfg();
        this.repType = repositoryConfig.getRepositoryType();
        this.supportsBranchFilter = repositoryConfig.isSupportsBranchFilter();
        this.supportsCommitGraph = repositoryConfig.isSupportsCommitGraph();
        this.revisions = new ArrayList<FileRevision>();
        String string = this.selectedBranch = params.getWbSpec() == null ? null : params.getWbSpec().getBranch();
        if (this.selectedBranch == null) {
            this.selectedBranch = repository.engine.getPathMatcher().getBranch(params.getPath());
        }
        this.defaultBranch = params.getDefaultBranch();
        IntOpenHashSet revids = new IntOpenHashSet();
        Map<String, Collection<FileRevision>> infoMap = params.getHistExplorer().getInfoMap();
        for (String branch : params.getHistExplorer().getBranchNames()) {
            Collection<FileRevision> fileRevisions = infoMap.get(branch);
            this.addApplicableRevisions(revisionsOfInterest, fileRevisions, (IntSet)revids);
        }
        this.addApplicableRevisions(revisionsOfInterest, params.getHistExplorer().getNonBranchRevisions(), (IntSet)revids);
        Collections.sort(this.revisions, new Comparator<FileRevision>(){

            @Override
            public int compare(FileRevision r1, FileRevision r2) {
                if (r1.getDateValue() == null) {
                    return r2.getDateValue() == null ? 0 : 1;
                }
                return r2.getDateValue() == null ? -1 : -r1.getDateValue().compareTo(r2.getDateValue());
            }
        });
    }

    private void addApplicableRevisions(Set<Integer> revisionsOfInterest, Collection<FileRevision> fileRevisions, IntSet revids) {
        for (FileRevision rev : fileRevisions) {
            if (this.firstRevision == null) {
                this.firstRevision = rev.getRevision();
            }
            if (!revisionsOfInterest.isEmpty() && !revisionsOfInterest.contains(rev.getRevID())) continue;
            this.addRevision(revids, rev);
        }
    }

    private void addRevision(IntSet revids, FileRevision rev) {
        if (!revids.contains(rev.getRevID())) {
            revids.add(rev.getRevID());
            this.revisions.add(rev);
        }
    }

    public String getLatestRevision() {
        return this.firstRevision;
    }

    public String getRepType() {
        return this.repType.id;
    }

    public List<FileRevision> getRevisions() {
        return this.revisions;
    }

    public Set<FileRevision> getUniqueRevisions() {
        if (this.uniqueRevisions == null) {
            this.uniqueRevisions = new LinkedHashSet<FileRevision>();
            this.uniqueRevisions.addAll(this.revisions);
            if (this.uniqueRevisions.size() != this.revisions.size()) {
                int sizeDiff = this.revisions.size() - this.uniqueRevisions.size();
                Logs.APP_LOG.debug((Object)(sizeDiff + " duplicate revisions have been detected"));
            }
        }
        return this.uniqueRevisions;
    }

    public String getRepName() {
        return this.repName;
    }

    public String getPath() {
        return this.path;
    }

    public String getFpath() {
        return this.repName + "/" + this.path;
    }

    public boolean isSupportsBranchFilter() {
        return this.supportsBranchFilter;
    }

    public boolean isSupportsCommitGraph() {
        return this.supportsCommitGraph;
    }

    public String getSelectedBranch() {
        return this.selectedBranch;
    }

    @Nullable
    public String getDefaultBranch() {
        return this.defaultBranch;
    }
}

