/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.dirtree;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.LogicalPathMatcher;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.base.Strings;

public class PathFilterFactory {
    public static PathFilter getPathFilter(RepositoryEngine eng, WaybackSpec wb) {
        String tag = wb == null ? null : wb.getTag();
        LogicalPathMatcher matcher = eng.getPathMatcher();
        if (!Strings.isNullOrEmpty((String)tag) && matcher instanceof SvnLogicalPathMatcher) {
            return new SvnTagPathFilter((SvnLogicalPathMatcher)matcher, tag);
        }
        return null;
    }

    public static class SvnTagPathFilter
    implements PathFilter {
        private final SvnLogicalPathMatcher matcher;
        private final String tag;

        public SvnTagPathFilter(SvnLogicalPathMatcher matcher, String tag) {
            this.matcher = matcher;
            this.tag = tag;
        }

        @Override
        public boolean shouldIgnore(Path path) {
            return path != null && this.matcher.getLogicalPath(path) != null && !this.tag.equals(this.matcher.getTag(path));
        }
    }

    public static interface PathFilter {
        public boolean shouldIgnore(Path var1);
    }
}

