/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.dirtree;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.fisheye.scm.DirTreeData;
import com.atlassian.fisheye.scm.RepositoryExplorer;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.dirtree.AbstractLoadSubTreeAction;
import javax.annotation.Resource;

public class LoadSubTreeAction
extends AbstractLoadSubTreeAction {
    @Resource
    private SourceFactory sourceFactory;
    @Resource
    private TxTemplate txTemplate;
    protected boolean noFiles;
    protected String selectedPath;
    private WaybackSpec wbSpec;

    @Override
    protected DirTreeData makeDirTree() throws DbException {
        String baseUrl = this.getBaseUrl();
        String contextPath = this.request.getContextPath();
        String pathInfoString = baseUrl.substring(baseUrl.indexOf(contextPath) + contextPath.length() + 1);
        pathInfoString = pathInfoString.substring(pathInfoString.indexOf("/") + 1) + "/" + this.path;
        FishEyePathInfo pathInfo = new FishEyePathInfo(pathInfoString);
        this.wbSpec = this.parseWaybackSpec(pathInfo);
        Source s2 = this.sourceFactory.getSource(this.repName, this.txTemplate.getEffectivePrincipal());
        Path subTreeRoot = new Path(this.path);
        RepositoryExplorer explorer = s2.getRepositoryExplorer(subTreeRoot, this.wbSpec, PreferenceManager.getPreferences(CrucibleFilter.getRequest()));
        return explorer.getDirTreeData(subTreeRoot, this.selectedPath == null ? subTreeRoot : new Path(this.selectedPath), this.noFiles);
    }

    protected WaybackSpec parseWaybackSpec(FishEyePathInfo pi) {
        WaybackSpec wbSpec = WaybackSpec.fromPathInfo(pi);
        return wbSpec != null ? wbSpec : new WaybackSpec();
    }

    public Boolean getNoFiles() {
        return this.noFiles;
    }

    public void setNoFiles(Boolean noFiles) {
        this.noFiles = noFiles;
    }

    public void setSelectedPath(String selectedPath) {
        this.selectedPath = selectedPath;
    }

    @Override
    public WaybackSpec getWbSpec() {
        return this.wbSpec;
    }

    @Override
    @RequireSecurityToken(value=false)
    public String execute() {
        return super.execute();
    }
}

